/*
 * Decompiled with CFR 0.152.
 */
package com.am.activity.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class AudioManager
extends Thread
implements PlayerListener {
    private static boolean audioEnabled = true;
    private static final int MAX_PLAYERS = 4;
    private static AudioManager instance;
    private static final Vector playBuffer;
    private boolean stopElectricity = false;
    private PlayItem[] players = new PlayItem[4];
    private int index = 0;
    static /* synthetic */ Class class$0;

    static {
        playBuffer = new Vector();
        instance = new AudioManager();
        instance.start();
    }

    public static AudioManager getInstance() {
        if (instance == null) {
            instance = new AudioManager();
        }
        return instance;
    }

    public void stopAll() {
        int i = 0;
        while (i < this.players.length) {
            if (this.players[i] != null) {
                this.stop(this.players[i].getPlayer());
            }
            ++i;
        }
    }

    public void stopPlayer(String key) {
        this.stopElectricity = true;
        int i = 0;
        while (i < this.players.length) {
            if (this.players[i] != null && this.players[i].filename.equals(key)) {
                this.stop(this.players[i].getPlayer());
            }
            ++i;
        }
    }

    public void stop(Player player) {
        if (player.getState() == 400) {
            try {
                player.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        player.close();
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("endOfMedia")) {
            try {
                player.setMediaTime(0L);
                player.start();
            }
            catch (MediaException me) {
                me.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            if (audioEnabled) {
                PlayItem[] queue;
                Enumeration e2 = null;
                Vector vector = playBuffer;
                synchronized (vector) {
                    queue = new PlayItem[playBuffer.size()];
                    e2 = playBuffer.elements();
                    int i = 0;
                    while (i < playBuffer.size()) {
                        queue[i] = (PlayItem)e2.nextElement();
                        ++i;
                    }
                    playBuffer.removeAllElements();
                }
                int i = 0;
                while (i < queue.length) {
                    PlayItem playItem = queue[i];
                    if (this.players[this.index] != null) {
                        this.stop(this.players[this.index].getPlayer());
                    }
                    this.players[this.index] = playItem;
                    ++this.index;
                    if (this.index >= 4) {
                        this.index = 0;
                    }
                    try {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("com.am.activity.tools.AudioManager");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        InputStream stream = clazz.getResourceAsStream(playItem.getFilename());
                        playItem.setPlayer(Manager.createPlayer((InputStream)stream, (String)"audio/mp3"));
                        playItem.getPlayer().start();
                        if (playItem.looped) {
                            playItem.getPlayer().addPlayerListener((PlayerListener)this);
                            if (this.stopElectricity) {
                                playItem.getPlayer().stop();
                                this.stopElectricity = false;
                            }
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (MediaException ex) {
                        ex.printStackTrace();
                    }
                    catch (RuntimeException rex) {
                        rex.getMessage();
                        rex.printStackTrace();
                    }
                    ++i;
                }
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loopSample(String filename) {
        this.stopElectricity = false;
        PlayItem playItem = new PlayItem(filename, true);
        Vector vector = playBuffer;
        synchronized (vector) {
            if (playBuffer.size() < 4) {
                playBuffer.addElement(playItem);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSample(String filename) {
        PlayItem playItem = new PlayItem(filename, false);
        Vector vector = playBuffer;
        synchronized (vector) {
            playBuffer.addElement(playItem);
            while (playBuffer.size() >= 4) {
                playBuffer.removeElementAt(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAudioEnabled(boolean value) {
        Vector vector = playBuffer;
        synchronized (vector) {
            playBuffer.removeAllElements();
        }
        audioEnabled = value;
    }

    private class PlayItem {
        public Player player;
        public String filename;
        public boolean looped;

        public PlayItem(String filename, boolean looped) {
            this.filename = filename;
            this.looped = looped;
        }

        public String getFilename() {
            return this.filename;
        }

        public Player getPlayer() {
            return this.player;
        }

        public void setPlayer(Player player) {
            this.player = player;
        }
    }
}

