/*
 * Decompiled with CFR 0.152.
 */
package com.am.activity.tools;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.microedition.lcdui.Font;

public class TextReader {
    private static TextReader instance;
    private static String ENCODE;

    static {
        ENCODE = "UTF-8";
    }

    public static TextReader getInstance() {
        if (instance == null) {
            instance = new TextReader();
        }
        return instance;
    }

    public String readTextToString(String filename) throws UnsupportedEncodingException {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(filename), ENCODE);
        String line = null;
        String result = "";
        try {
            while ((line = this.readLine(reader)) != null) {
                result = String.valueOf(result) + line;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        try {
            ((Reader)reader).close();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        return result;
    }

    public String readFile(String filename) throws IOException {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(filename), ENCODE);
        String line = null;
        String result = null;
        while ((line = this.readLine(reader)) != null) {
            result = String.valueOf(result) + line;
        }
        ((Reader)reader).close();
        return result;
    }

    public String[] readFileToArray(String filename) throws IOException {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(filename), ENCODE);
        String line = null;
        Vector<String> str = new Vector<String>();
        while ((line = this.readLine(reader)) != null) {
            str.addElement(line);
        }
        String[] result = new String[str.size()];
        if (str.size() > 0) {
            int loop = 0;
            while (loop < str.size()) {
                result[loop] = (String)str.elementAt(loop);
                ++loop;
            }
        }
        ((Reader)reader).close();
        return result;
    }

    private String readLine(Reader reader) throws IOException {
        int readChar = reader.read();
        if (readChar == -1) {
            return null;
        }
        StringBuffer string = new StringBuffer("");
        while (readChar != -1 && readChar != 10) {
            if (readChar != 13) {
                string.append((char)readChar);
            }
            readChar = reader.read();
        }
        return string.toString();
    }

    public static String[] split(String original, String separator) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            nodes.addElement(original.substring(0, index));
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        String[] result = new String[nodes.size()];
        if (nodes.size() > 0) {
            int loop = 0;
            while (loop < nodes.size()) {
                result[loop] = (String)nodes.elementAt(loop);
                ++loop;
            }
        }
        return result;
    }

    public static String[] splitStringByWidth(String stringToSplit, Font font, int width) {
        StringBuffer strBuf = new StringBuffer();
        Vector<String> strResult = new Vector<String>();
        String[] workStr = TextReader.split(stringToSplit, " ");
        strBuf.append(workStr[0]);
        int i = 1;
        while (i < workStr.length) {
            if (font.stringWidth(strBuf.toString()) + font.stringWidth(workStr[i]) <= width) {
                strBuf.append(" ").append(workStr[i]);
            } else {
                strResult.addElement(strBuf.toString());
                strBuf.delete(0, strBuf.length());
                strBuf.append(workStr[i]);
            }
            if (font.stringWidth(strBuf.toString()) <= width & i == workStr.length - 1) {
                strResult.addElement(strBuf.toString());
                strBuf.delete(0, strBuf.length());
            }
            ++i;
        }
        strBuf.delete(0, strBuf.length());
        String[] result = new String[strResult.size()];
        if (strResult.size() > 0) {
            int loop = 0;
            while (loop < strResult.size()) {
                result[loop] = (String)strResult.elementAt(loop);
                ++loop;
            }
        }
        return result;
    }
}

