/*
 * Decompiled with CFR 0.152.
 */
package com.am.asha_inapp;

import com.am.asha_inapp.Payment;
import com.am.asha_inapp.PaymentStat;
import com.am.asha_inapp.ProductInfo;
import com.am.asha_inapp.ProductStore;
import com.am.ashamidlet.AshaMidlet;
import com.nokia.payment.NPayException;
import com.nokia.payment.NPayListener;
import com.nokia.payment.NPayManager;
import com.nokia.payment.ProductData;
import com.nokia.payment.PurchaseData;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class AshaPaymentManager
implements Payment,
NPayListener {
    private static final String SEPARATOR = "|";
    private static final String MICROEDITION_LOCALE = "microedition.locale";
    private static final String PATH_ = "/loc";
    private static final String TXT = ".txt";
    private static final String DEFAULT_LOCALE = "_EN";
    private static Hashtable text = new Hashtable();
    private static Hashtable listLocale = new Hashtable();
    private static String[] strLocale = new String[]{"_EN", "_ES", "_RU", "_CN"};
    private static String[] strKey = new String[]{"en", "es", "ru", "zh"};
    private static String locale;
    private static String TITLE;
    private static String MESSAGE;
    private static String SETUP;
    private static String EXIT;
    MIDlet midlet;
    AshaMidlet asha;
    PaymentStat stat;
    private NPayManager paymentManager = null;
    private ProductStore productStore = null;
    private Hashtable products = new Hashtable();
    private String nameRms = "payments";
    Alert alert;
    private String[] productIds;

    public void setNewProduct(String productName, String productId) {
        this.products.put(productName, ProductInfo.createProductInfo(productName, productId));
    }

    public boolean isPaid(String productName) {
        ProductInfo pi = this.getProductInfo(productName);
        if (pi.isPaid) {
            return pi.isPaid;
        }
        return false;
    }

    public void purchaseProduct(String productName) {
        ProductInfo pi = this.getProductInfo(productName);
        try {
            this.paymentManager.purchaseProduct(pi.productId);
        }
        catch (NPayException e2) {
            e2.printStackTrace();
        }
    }

    public void initInApp(MIDlet midlet, PaymentStat stat) {
        this.midlet = midlet;
        this.asha = (AshaMidlet)midlet;
        this.stat = stat;
        if (locale == null) {
            locale = AshaPaymentManager.identifyLocale();
        }
        StringBuffer pathToFile = new StringBuffer();
        pathToFile.append(PATH_).append(locale).append(TXT);
        try {
            this.initTextRes(pathToFile.toString());
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (!this.products.isEmpty()) {
            this.productStore = new ProductStore(this.nameRms);
            try {
                this.paymentManager = new NPayManager(midlet);
                this.paymentManager.setNPayListener(this);
            }
            catch (NPayException e2) {
                e2.printStackTrace();
            }
            int len = this.products.size();
            this.productIds = new String[len];
            Enumeration productEnum = this.products.elements();
            int index = 0;
            while (productEnum.hasMoreElements()) {
                ProductInfo productInfo = (ProductInfo)productEnum.nextElement();
                if (this.productStore.isPurchased(productInfo.productName)) {
                    productInfo.isPaid = true;
                }
                this.productIds[index] = productInfo.productId;
                ++index;
            }
            try {
                this.paymentManager.getProductData(this.productIds);
            }
            catch (NPayException e3) {
                e3.printStackTrace();
            }
            if (!this.paymentManager.isNPayAvailable()) {
                this.askForMidletInstallation();
                return;
            }
        }
    }

    public void productDataReceived(ProductData[] dataItems) {
        int len = dataItems.length;
        int i = 0;
        while (i < len) {
            ProductData productData = dataItems[i];
            ProductInfo pi = this.getProductInfoByID(productData.getProductId());
            pi.setProductData(productData);
            ++i;
        }
    }

    public void purchaseCompleted(PurchaseData data) {
        if (data.getStatus() == 0) {
            ProductInfo pi = this.getProductInfoByID(data.getProductId());
            pi.isPaid = true;
            this.productStore.savePayment(pi);
            this.stat.sendPaymentStat(pi.data.getLocalizedPrice(), pi.data.getCurrency());
            return;
        }
        if (data.getStatus() == 2) {
            ProductInfo pi = this.getProductInfoByID(data.getProductId());
            pi.isPaid = true;
            this.productStore.savePayment(pi);
            return;
        }
        if (data.getStatus() == 1) {
            return;
        }
    }

    public ProductInfo getProductInfo(String productName) {
        return (ProductInfo)this.products.get(productName);
    }

    public ProductInfo getProductInfoByID(String productId) {
        Enumeration productEnum = this.products.elements();
        while (productEnum.hasMoreElements()) {
            ProductInfo productInfo = (ProductInfo)productEnum.nextElement();
            if (!productInfo.productId.equals(productId)) continue;
            return productInfo;
        }
        return null;
    }

    private void askForMidletInstallation() {
        this.alert = new Alert(TITLE, MESSAGE, null, AlertType.CONFIRMATION);
        final Command cmdInstallEnabler = new Command(SETUP, 4, 1);
        final Command cmdExit = new Command(EXIT, 3, 2);
        this.alert.addCommand(cmdInstallEnabler);
        this.alert.addCommand(cmdExit);
        this.alert.setTimeout(-2);
        this.alert.setCommandListener(new CommandListener(){

            public void commandAction(Command c2, Displayable d2) {
                if (c2 == cmdInstallEnabler) {
                    try {
                        AshaPaymentManager.this.paymentManager.launchNPaySetup();
                    }
                    catch (IllegalStateException e2) {
                        e2.printStackTrace();
                    }
                    catch (ConnectionNotFoundException e3) {
                        e3.printStackTrace();
                    }
                }
                if (c2 == cmdExit) {
                    AshaPaymentManager.this.midlet.notifyDestroyed();
                }
            }
        });
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.alert);
    }

    public boolean consume(String productName) {
        ProductInfo pi = this.getProductInfo(productName);
        if (pi.isPaid) {
            pi.isPaid = false;
            this.productStore.deletePayment(pi);
            return true;
        }
        return false;
    }

    public String getCost(String productName) {
        return this.getProductInfo((String)productName).data.getLocalizedPrice();
    }

    public String getCurrency(String productName) {
        return this.getProductInfo((String)productName).data.getCurrency();
    }

    public String getLocalizedPrice(String productName) {
        return this.getProductInfo((String)productName).data.getLocalizedPrice();
    }

    public String getProductId(String productName) {
        return this.getProductInfo((String)productName).productId;
    }

    private void readFile(String filename) throws UnsupportedEncodingException, IOException {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(filename), "UTF-8");
        String line = null;
        while ((line = this.readLine(reader)) != null) {
            String[] result = this.split(line, SEPARATOR);
            text.put(result[0], result[1]);
        }
        ((Reader)reader).close();
    }

    private String readLine(Reader reader) throws IOException {
        int readChar = reader.read();
        if (readChar == -1) {
            return null;
        }
        StringBuffer string = new StringBuffer("");
        while (readChar != -1 && readChar != 10) {
            if (readChar != 13) {
                string.append((char)readChar);
            }
            readChar = reader.read();
        }
        return string.toString();
    }

    private String[] split(String original, String separator) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            nodes.addElement(new String(original.substring(0, index)));
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        String[] result = new String[nodes.size()];
        if (nodes.size() > 0) {
            int loop = 0;
            while (loop < nodes.size()) {
                result[loop] = (String)nodes.elementAt(loop);
                ++loop;
            }
        }
        return result;
    }

    private static String identifyLocale() {
        String locale;
        if (listLocale.isEmpty()) {
            int i = 0;
            while (i < strLocale.length) {
                listLocale.put(strKey[i], strLocale[i]);
                ++i;
            }
        }
        if ((locale = System.getProperty(MICROEDITION_LOCALE)).length() > 2) {
            locale = locale.substring(0, 2);
        }
        String result = null;
        Object value = listLocale.get(locale);
        result = value != null ? (String)value : DEFAULT_LOCALE;
        return result;
    }

    private void initTextRes(String filename) throws UnsupportedEncodingException, IOException {
        if (!text.isEmpty()) {
            text.clear();
        }
        this.readFile(filename);
        TITLE = this.get("TITLE");
        MESSAGE = this.get("MESSAGE");
        SETUP = this.get("SETUP");
        EXIT = this.get("EXIT");
    }

    private String get(String key) {
        String result = null;
        Object value = text.get(key);
        result = value != null ? (String)value : " ";
        return result;
    }
}

