/*
 * Decompiled with CFR 0.152.
 */
package com.am.asha_inapp;

import com.am.asha_inapp.ProductInfo;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class ProductStore {
    private RecordStore paymentStore = null;
    private String repositoryName;

    public ProductStore(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public void savePayment(ProductInfo pi) {
        String productName = pi.productName;
        try {
            this.paymentStore = RecordStore.openRecordStore((String)this.repositoryName, (boolean)true);
            if (!this.isRecordExist(productName)) {
                byte[] record = productName.getBytes();
                this.paymentStore.addRecord(record, 0, record.length);
            }
            this.paymentStore.closeRecordStore();
        }
        catch (Exception e2) {
            System.out.println(e2.toString());
        }
    }

    public void deletePayment(ProductInfo pi) {
        String productName = pi.productName;
        try {
            this.paymentStore = RecordStore.openRecordStore((String)this.repositoryName, (boolean)true);
            int indexRecord = this.isRecordIndex(productName);
            System.out.println("index is: " + indexRecord);
            if (indexRecord >= 0) {
                this.paymentStore.deleteRecord(indexRecord);
            }
            this.paymentStore.closeRecordStore();
        }
        catch (Exception e2) {
            System.out.println(e2.toString());
        }
    }

    public boolean isPurchased(String productName) {
        boolean purchased = false;
        try {
            this.paymentStore = RecordStore.openRecordStore((String)this.repositoryName, (boolean)false);
            purchased = this.isRecordExist(productName);
            this.paymentStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return purchased;
    }

    private boolean isRecordExist(String productName) {
        boolean recordExist;
        block3: {
            recordExist = false;
            try {
                if (this.paymentStore == null) break block3;
                RecordEnumeration paymentEnum = this.paymentStore.enumerateRecords(null, null, false);
                while (paymentEnum.hasNextElement()) {
                    String element = new String(paymentEnum.nextRecord());
                    if (!element.equals(productName)) continue;
                    recordExist = true;
                    break;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return recordExist;
    }

    private int isRecordIndex(String productName) {
        int recordIndex;
        block3: {
            recordIndex = -1;
            try {
                if (this.paymentStore == null) break block3;
                RecordEnumeration paymentEnum = this.paymentStore.enumerateRecords(null, null, false);
                while (paymentEnum.hasNextElement()) {
                    String element = new String(paymentEnum.nextRecord());
                    if (!element.equals(productName)) continue;
                    recordIndex = paymentEnum.numRecords();
                    break;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return recordIndex;
    }
}

