/*
 * Decompiled with CFR 0.152.
 */
package com.am.blockapplib.utils;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.microedition.lcdui.Font;

public class TextReader {
    private static TextReader instance;
    private static String ENCODE;

    static {
        ENCODE = "UTF-8";
    }

    public static TextReader getInstance() {
        if (instance == null) {
            instance = new TextReader();
        }
        return instance;
    }

    public String readTextToString(String filename) throws UnsupportedEncodingException {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(filename), ENCODE);
        String line = null;
        String result = "";
        try {
            while ((line = this.readLine(reader)) != null) {
                result = String.valueOf(result) + line;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        try {
            ((Reader)reader).close();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        return result;
    }

    public String readFile(String filename) throws IOException {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(filename));
        String line = null;
        String result = null;
        while ((line = this.readLine(reader)) != null) {
            result = String.valueOf(result) + line;
        }
        ((Reader)reader).close();
        return result;
    }

    public static String replace(String needle, String replacement, String haystack) {
        String result = "";
        int index = haystack.indexOf(needle);
        if (index == 0) {
            result = String.valueOf(replacement) + haystack.substring(needle.length());
            return TextReader.replace(needle, replacement, result);
        }
        if (index > 0) {
            result = String.valueOf(haystack.substring(0, index)) + replacement + haystack.substring(index + needle.length());
            return TextReader.replace(needle, replacement, result);
        }
        return haystack;
    }

    public Vector readFileLines(String filename) throws IOException {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(filename));
        String line = null;
        Vector<String> result = new Vector<String>();
        while ((line = this.readLine(reader)) != null) {
            result.addElement(line);
        }
        ((Reader)reader).close();
        return result;
    }

    private String readLine(Reader reader) throws IOException {
        int readChar = reader.read();
        if (readChar == -1) {
            return null;
        }
        StringBuffer string = new StringBuffer("");
        while (readChar != -1 && readChar != 10) {
            if (readChar != 13) {
                string.append((char)readChar);
            }
            readChar = reader.read();
        }
        return string.toString();
    }

    public static String[] split(String original, String separator) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            nodes.addElement(original.substring(0, index));
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        String[] result = new String[nodes.size()];
        if (nodes.size() > 0) {
            int loop = 0;
            while (loop < nodes.size()) {
                result[loop] = (String)nodes.elementAt(loop);
                ++loop;
            }
        }
        return result;
    }

    public static String[] getTextRows(String text, Font font, int width) {
        char spaceChar = ' ';
        Vector<String> rowsVector = new Vector<String>();
        StringBuffer currentRowText = new StringBuffer();
        int prevIndex = 0;
        int currIndex = text.indexOf(spaceChar);
        if (currIndex == -1) {
            currIndex = text.length();
        }
        int rowWidth = 0;
        int tokenWidth = 0;
        int whitespaceWidth = font.stringWidth(" ");
        String currentToken = null;
        while (currIndex != -1) {
            currentToken = text.substring(prevIndex, currIndex);
            tokenWidth = font.stringWidth(currentToken);
            rowWidth += tokenWidth;
            if (currentRowText.length() > 0) {
                rowWidth += whitespaceWidth;
            }
            if (currentRowText.length() > 0 && rowWidth > width) {
                rowsVector.addElement(currentRowText.toString());
                currentRowText.setLength(0);
                currentRowText.append(currentToken);
                rowWidth = tokenWidth;
            } else {
                if (currentRowText.length() > 0) {
                    currentRowText.append(spaceChar);
                }
                currentRowText.append(currentToken);
            }
            if (currIndex == text.length()) break;
            prevIndex = currIndex + 1;
            if ((currIndex = text.indexOf(spaceChar, prevIndex)) != -1) continue;
            currIndex = text.length();
        }
        if (currentRowText.length() > 0) {
            rowsVector.addElement(currentRowText.toString());
        }
        String[] rowsArray = new String[rowsVector.size()];
        int i = 0;
        while (i < rowsArray.length) {
            rowsArray[i] = (String)rowsVector.elementAt(i);
            ++i;
        }
        return rowsArray;
    }
}

