/*
 * Decompiled with CFR 0.152.
 */
package com.am.blockapplib.utils;

import com.am.blockapplib.utils.TextReader;

public class Time {
    int hours;
    int mins;
    int secs;

    public Time(float seconds) {
        this.hours = (int)seconds / 3600;
        int remainder = (int)seconds - this.hours * 3600;
        this.mins = remainder / 60;
        this.secs = remainder -= this.mins * 60;
    }

    public Time(String timeString) {
        String[] timeArray = TextReader.split(timeString, ":");
        if (timeArray.length > 3) {
            throw new IllegalArgumentException();
        }
        switch (timeArray.length) {
            case 3: {
                this.hours = Integer.valueOf(timeArray[0]);
                this.mins = Integer.valueOf(timeArray[1]);
                this.secs = Integer.valueOf(timeArray[2]);
                break;
            }
            case 2: {
                this.hours = 0;
                this.mins = Integer.valueOf(timeArray[0]);
                this.secs = Integer.valueOf(timeArray[1]);
                break;
            }
            case 1: {
                this.hours = 0;
                this.mins = 0;
                this.secs = Integer.valueOf(timeArray[0]);
                break;
            }
            case 0: {
                this.hours = 0;
                this.mins = 0;
                this.secs = 0;
            }
        }
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.mins;
    }

    public int getSeconds() {
        return this.secs;
    }

    public String toString() {
        return String.valueOf(this.hours) + ":" + this.mins + ":" + this.secs;
    }

    public int toSeconds() {
        int seconds = this.hours * 3600 + this.mins * 60 + this.secs;
        return seconds;
    }

    public long toMilliSeconds() {
        return this.toSeconds() * 1000;
    }
}

