/*
 * Decompiled with CFR 0.152.
 */
package com.am.component;

import com.am.component.Component;
import com.am.component.Paintable;
import com.am.component.PointerHandler;
import com.am.component.SimpleComponent;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Container
extends SimpleComponent {
    protected Vector paintables = new Vector();
    protected Vector pointerHandlers = new Vector();
    private boolean visible = true;

    public Container() {
    }

    public Container(int width, int height) {
        this.setSize(width, height);
    }

    public void addComponent(Component component) {
        this.addPaintable(component);
        this.addPointerHandler(component);
    }

    public boolean removeComponent(Component component) {
        boolean res1 = this.removePointerHandler(component);
        boolean res2 = this.removePaintable(component);
        return res1 && res2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPaintable(Paintable paintable) {
        Vector vector = this.paintables;
        synchronized (vector) {
            this.paintables.addElement(paintable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePaintable(Paintable paintable) {
        Vector vector = this.paintables;
        synchronized (vector) {
            Vector newPaintables = new Vector();
            boolean result = this.CopyToVectorWithout(this.paintables, newPaintables, paintable);
            this.paintables = newPaintables;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPointerHandler(PointerHandler pointerHandler) {
        Vector vector = this.pointerHandlers;
        synchronized (vector) {
            this.pointerHandlers.addElement(pointerHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePointerHandler(PointerHandler pointerHandler) {
        Vector vector = this.pointerHandlers;
        synchronized (vector) {
            Vector newPointerHandlers = new Vector();
            boolean result = this.CopyToVectorWithout(this.pointerHandlers, newPointerHandlers, pointerHandler);
            this.pointerHandlers = newPointerHandlers;
            return result;
        }
    }

    public void paint(Graphics g2) {
        if (!this.isVisible()) {
            return;
        }
        g2.translate(this.getX(), this.getY());
        Vector paintables = this.paintables;
        int n = paintables.size();
        for (int i = 0; i < n; ++i) {
            ((Paintable)paintables.elementAt(i)).paint(g2);
        }
        g2.translate(-this.getX(), -this.getY());
    }

    public boolean pointerDragged(int x, int y) {
        if (!this.isVisible()) {
            return false;
        }
        x -= this.getX();
        y -= this.getY();
        Vector pointerHandlers = this.pointerHandlers;
        for (int i = pointerHandlers.size() - 1; i >= 0; --i) {
            PointerHandler handler = (PointerHandler)pointerHandlers.elementAt(i);
            boolean result = handler.pointerDragged(x, y);
            if (!result) continue;
            return true;
        }
        return false;
    }

    public boolean pointerPressed(int x, int y) {
        if (!this.isVisible()) {
            return false;
        }
        x -= this.getX();
        y -= this.getY();
        Vector pointerHandlers = this.pointerHandlers;
        for (int i = pointerHandlers.size() - 1; i >= 0; --i) {
            PointerHandler handler = (PointerHandler)pointerHandlers.elementAt(i);
            boolean result = handler.pointerPressed(x, y);
            if (!result) continue;
            return true;
        }
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        if (!this.isVisible()) {
            return false;
        }
        x -= this.getX();
        y -= this.getY();
        Vector pointerHandlers = this.pointerHandlers;
        for (int i = pointerHandlers.size() - 1; i >= 0; --i) {
            PointerHandler handler = (PointerHandler)pointerHandlers.elementAt(i);
            boolean result = handler.pointerReleased(x, y);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private boolean CopyToVectorWithout(Vector from, Vector to, Object exclude) {
        boolean result = false;
        int n = from.size();
        for (int i = 0; i < n; ++i) {
            Object element = from.elementAt(i);
            if (element == exclude) continue;
            result = true;
            to.addElement(element);
        }
        return result;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

