/*
 * Decompiled with CFR 0.152.
 */
package com.am.component;

import com.am.component.SimpleComponent;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public final class ScrollText
extends SimpleComponent {
    private static final char[] DEFAULT_FORCE_SEPARATORS = "\n".toCharArray();
    private static final char[][] DEFAULT_SEPARATORS = new char[][]{"\t\r ".toCharArray(), ".;,:?@".toCharArray()};
    private char[] forceSeparators = DEFAULT_FORCE_SEPARATORS;
    private char[][] separators = DEFAULT_SEPARATORS;
    private String sourceText;
    private String[] lines;
    private Font font;
    private int textHeight;
    private int scrollPosition = 0;
    private int maxScrollPosition;
    private double scrollSpeed = 0.2;
    private int textColor = 0;
    private int scrollColor = 0;
    private int scrollWidth = 3;
    private boolean scrolling;
    private int capturedY;

    public ScrollText(Font font, int x, int y, int width, int height, String text) {
        this.font = font;
        this.sourceText = text;
        this.setPosition(x, y);
        this.setSize(width, height);
    }

    public ScrollText(Font font, int x, int y, int width, int height) {
        this(font, x, y, width, height, "");
    }

    public ScrollText(Font font, int width, int height, String text) {
        this(font, 0, 0, width, height, text);
    }

    public ScrollText(Font font, int width, int height) {
        this(font, 0, 0, width, height, "");
    }

    private void updateText() {
        this.lines = ScrollText.parseString(this.sourceText, this.getWidth() - this.scrollWidth, this.font, this.forceSeparators, this.separators);
        this.textHeight = this.lines.length * this.font.getHeight();
        this.maxScrollPosition = Math.max(this.textHeight - this.getHeight(), 0);
        this.scrollPosition = Math.min(this.scrollPosition, this.maxScrollPosition);
    }

    public void setText(String text) {
        this.sourceText = text == null ? "" : text;
        this.updateText();
    }

    public void setFont(Font font) {
        this.font = font;
        this.updateText();
    }

    public void setSize(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("Width can't be negative");
        }
        if (height < 0) {
            throw new IllegalArgumentException("Height can't be negative");
        }
        super.setSize(width, height);
        this.updateText();
    }

    public void setScrollSpeed(double scrollSpeed) {
        this.scrollSpeed = scrollSpeed;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void setScrollColor(int scrollColor) {
        this.scrollColor = scrollColor;
    }

    public void setScrollWidth(int scrollWidth) {
        if (scrollWidth < 0) {
            throw new IllegalArgumentException("Scrollbar width can't be negative");
        }
        this.scrollWidth = scrollWidth;
    }

    public void setSeparators(char[][] separators) {
        this.separators = separators;
        this.updateText();
    }

    public String getText() {
        return this.sourceText;
    }

    public Font getFont() {
        return this.font;
    }

    public double getScrollSpeed() {
        return this.scrollSpeed;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public int getScrollColor() {
        return this.scrollColor;
    }

    public int getScrollWidth() {
        return this.scrollWidth;
    }

    public boolean pointerPressed(int x, int y) {
        if (this.containsPoint(x, y)) {
            this.scrolling = true;
            this.capturedY = y;
            return true;
        }
        this.scrolling = false;
        return false;
    }

    public boolean pointerDragged(int x, int y) {
        if (this.scrolling && this.containsPoint(x, y)) {
            int pos = this.scrollPosition - (int)(this.scrollSpeed * (double)(y - this.capturedY));
            this.scrollPosition = Math.min(this.maxScrollPosition, Math.max(0, pos));
            return true;
        }
        this.scrolling = false;
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        boolean result = this.scrolling;
        this.scrolling = false;
        return result;
    }

    private boolean containsPoint(int x, int y) {
        int rx = x - this.getX();
        int ry = y - this.getY();
        return rx >= 0 && ry >= 0 && rx <= this.getWidth() && ry <= this.getHeight();
    }

    public void paint(Graphics g2) {
        int oldClipX = g2.getClipX();
        int oldClipY = g2.getClipY();
        int oldClipWidth = g2.getClipWidth();
        int oldClipHeight = g2.getClipHeight();
        int oldColor = g2.getColor();
        Font oldFont = g2.getFont();
        g2.clipRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        g2.setFont(this.font);
        g2.setColor(this.textColor);
        int startLine = this.scrollPosition / this.font.getHeight();
        int endLine = 1 + (this.scrollPosition + this.getHeight()) / this.font.getHeight();
        endLine = Math.min(endLine, this.lines.length - 1);
        int lineY = this.getY() + startLine * this.font.getHeight() - this.scrollPosition;
        for (int line = startLine; line <= endLine; ++line) {
            g2.drawString(this.lines[line], this.getX(), lineY, 20);
            lineY += this.font.getHeight();
        }
        if (this.maxScrollPosition > 0) {
            g2.setColor(this.scrollColor);
            int scrollX = this.getX() + this.getWidth() - this.scrollWidth;
            int scrollY = this.getY() + this.scrollPosition * this.getHeight() / this.textHeight;
            int scrollHeight = this.getHeight() * this.getHeight() / this.textHeight;
            g2.fillRect(scrollX, scrollY, this.scrollWidth, scrollHeight);
        }
        g2.setColor(oldColor);
        g2.setFont(oldFont);
        g2.setClip(oldClipX, oldClipY, oldClipWidth, oldClipHeight);
    }

    private static String[] parseString(String sourceText, int maxWidth, Font font, char[] forceSeparators, char[][] separators) {
        if (sourceText == null) {
            throw new IllegalArgumentException("Source string can't be null");
        }
        if (maxWidth < 0) {
            throw new IllegalArgumentException("Width must be greater than 0");
        }
        if (font == null) {
            throw new IllegalArgumentException("Font can't be null");
        }
        if (forceSeparators == null) {
            forceSeparators = new char[]{};
        }
        if (separators == null) {
            separators = new char[0][0];
        }
        Vector<String> accumulator = new Vector<String>();
        while (sourceText.length() > 0) {
            int position;
            int previousSeparatorPosition = -1;
            int previousSeparatorLevel = separators.length - 1;
            int width = 0;
            block1: for (position = 0; position < sourceText.length(); ++position) {
                char c2 = sourceText.charAt(position);
                if ((width += font.charWidth(c2)) > maxWidth) {
                    if (previousSeparatorPosition >= 0) {
                        position = previousSeparatorPosition + 1;
                        break;
                    }
                    if (position != 0) break;
                    position = 1;
                    break;
                }
                if (ScrollText.containsChar(forceSeparators, c2)) {
                    ++position;
                    break;
                }
                for (int i = 0; i <= previousSeparatorLevel; ++i) {
                    if (!ScrollText.containsChar(separators[i], c2)) continue;
                    previousSeparatorPosition = position;
                    previousSeparatorLevel = i;
                    continue block1;
                }
            }
            accumulator.addElement(sourceText.substring(0, position));
            sourceText = sourceText.substring(position);
        }
        Object[] result = new String[accumulator.size()];
        accumulator.copyInto(result);
        return result;
    }

    private static boolean containsChar(char[] cs, char c2) {
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] != c2) continue;
            return true;
        }
        return false;
    }
}

