/*
 * Decompiled with CFR 0.152.
 */
package com.am.component;

import com.am.component.Button;
import com.am.component.PaintableSprite;
import com.am.component.Spritesheet;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class SpriteButton
extends PaintableSprite
implements Button {
    private Runnable action;

    public SpriteButton(Spritesheet sheet) {
        super(sheet);
    }

    public SpriteButton(Image image) {
        super(image);
    }

    public SpriteButton(Image image, int frameWidth, int frameHeight) {
        super(image, frameWidth, frameHeight);
    }

    public SpriteButton(Sprite s) {
        super(s);
    }

    public boolean pointerPressed(int x, int y) {
        return this.isVisible() && this.contains(x, y);
    }

    public boolean pointerReleased(int x, int y) {
        if (!this.isVisible()) {
            return false;
        }
        boolean contains = this.contains(x, y);
        if (!contains) {
            return false;
        }
        Runnable action = this.action;
        if (action != null) {
            action.run();
        }
        return true;
    }

    public boolean pointerDragged(int x, int y) {
        return this.isVisible() && this.contains(x, y);
    }

    public void setAction(Runnable action) {
        this.action = action;
    }

    public boolean contains(int x, int y) {
        int thisX = this.getX();
        int thisY = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        return x >= thisX && y >= thisY && thisX + w >= x && thisY + h >= y;
    }
}

