/*
 * Decompiled with CFR 0.152.
 */
package com.am.engine;

import com.am.component.Component;
import com.am.engine.EngineScreen;
import com.am.engine.Event;
import com.am.engine.EventHandler;
import com.am.engine.LazyHandler;
import com.am.engine.LifetimeHandler;
import com.am.engine.RunnableHandler;
import com.am.engine.SimpleEvent;
import com.am.engine.TranslationHandler;
import com.nokia.mid.ui.DeviceControl;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class Engine
extends GameCanvas
implements CommandListener {
    public static final boolean CAN_USE_DEVICE_CONTROL = Engine.canUseDeviceControl();
    public static final Event EVENT_HIDE = new SimpleEvent("Hide");
    public static final Event EVENT_SHOW = new SimpleEvent("Show");
    public static final Event EVENT_BACK = new SimpleEvent("Back");
    public static final Event EVENT_MAIN_MENU = new SimpleEvent("Main Menu");
    public static final Event EVENT_EXIT = new SimpleEvent("Exit");
    public static final Event EVENT_HELP = new SimpleEvent("Help");
    public static final Event EVENT_ABOUT = new SimpleEvent("About");
    public static final Event EVENT_LEVEL_SELECTION = new SimpleEvent("Level Selection");
    public static final Event EVENT_NEXT_LEVEL = new SimpleEvent("Next Level");
    public static final Event EVENT_NEW_GAME = new SimpleEvent("New Game");
    public static final Event EVENT_PAUSE = new SimpleEvent("Pause");
    public static final Event EVENT_RESUME = new SimpleEvent("Resume");
    public static final Event EVENT_RESTART = new SimpleEvent("Restart");
    public static final Event EVENT_LOSS = new SimpleEvent("Loss");
    public static final Event EVENT_WIN = new SimpleEvent("Win");
    public static final Event EVENT_ERROR = new SimpleEvent("Error");
    public static final Event EVENT_MUTE = new SimpleEvent("Mute");
    public static final int DEFAULT_FPS = 15;
    private Component overlay;
    private volatile EngineScreen current;
    private Timer timer;
    private int fps = 15;
    private TimerTask task;
    private final Vector handlers = new Vector();
    private final Command backCommand = new Command("Back", 2, 0);

    public Engine(Timer timer) {
        super(true);
        if (timer == null) {
            throw new NullPointerException();
        }
        this.timer = timer;
        this.setFullScreenMode(true);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
    }

    public Engine() {
        this(new Timer());
    }

    public final void setFPS(int fps) {
        if (fps <= 0) {
            throw new IllegalArgumentException();
        }
        this.fps = fps;
    }

    public void setCurrent(EngineScreen screen) {
        if (screen != null) {
            screen.setEngine(this);
        }
        this.current = screen;
    }

    public void setOverlay(Component overlay) {
        this.overlay = overlay;
    }

    public EngineScreen getCurrent() {
        return this.current;
    }

    public void paint(Graphics g2) {
        Component overlay;
        EngineScreen current = this.current;
        if (current != null) {
            current.paint(g2);
        }
        if ((overlay = this.overlay) != null) {
            overlay.paint(g2);
        }
    }

    public synchronized void start() {
        if (this.timer == null) {
            throw new IllegalStateException();
        }
        if (this.task != null) {
            return;
        }
        this.task = new TimerTask(){

            public void run() {
                Engine.this.paint(Engine.this.getGraphics());
                Engine.this.flushGraphics();
                if (CAN_USE_DEVICE_CONTROL) {
                    DeviceControl.setLights((int)0, (int)100);
                }
            }
        };
        this.timer.schedule(this.task, 0L, (long)(1000 / this.fps));
    }

    public void stop() {
        TimerTask task = this.task;
        if (task != null) {
            task.cancel();
            this.task = null;
        }
    }

    public void close() {
        if (this.timer != null) {
            this.stop();
            this.timer.cancel();
            this.timer = null;
        }
    }

    public final void addHandler(EventHandler handler) {
        this.handlers.addElement(handler);
    }

    public void addLazyHandler(Event event, Class screenClass) {
        this.addHandler(new LazyHandler(event, screenClass));
    }

    public void addTranslationHandler(Event from, Event to) {
        this.addHandler(new TranslationHandler(from, to));
    }

    public void addLifetimeHandler(Event create, Event get, Event dispose, Class screenClass) {
        this.addHandler(new LifetimeHandler(create, get, dispose, screenClass));
    }

    public void addRunnableHandler(Event trigger, Runnable action) {
        this.addHandler(new RunnableHandler(trigger, action));
    }

    public void handleEvent(Event event) {
        try {
            int n = this.handlers.size();
            for (int i = 0; i < n; ++i) {
                EventHandler handler = (EventHandler)this.handlers.elementAt(i);
                handler.handleEvent(this, event);
            }
        }
        catch (Exception e2) {
            System.err.println("Exception while handling event " + event.toString() + ":");
            e2.printStackTrace();
        }
    }

    protected void pointerPressed(int x, int y) {
        Component overlay = this.overlay;
        if (overlay != null && overlay.pointerPressed(x, y)) {
            return;
        }
        EngineScreen current = this.current;
        if (current != null) {
            current.pointerPressed(x, y);
        }
    }

    protected void pointerDragged(int x, int y) {
        Component overlay = this.overlay;
        if (overlay != null && overlay.pointerDragged(x, y)) {
            return;
        }
        EngineScreen current = this.current;
        if (current != null) {
            current.pointerDragged(x, y);
        }
    }

    protected void pointerReleased(int x, int y) {
        Component overlay = this.overlay;
        if (overlay != null && overlay.pointerReleased(x, y)) {
            return;
        }
        EngineScreen current = this.current;
        if (current != null) {
            current.pointerReleased(x, y);
        }
    }

    public final void commandAction(Command c2, Displayable d2) {
        if (c2 == this.backCommand) {
            this.handleEvent(EVENT_BACK);
        }
    }

    public final void hideNotify() {
        this.handleEvent(EVENT_HIDE);
    }

    public final void showNotify() {
        this.handleEvent(EVENT_SHOW);
    }

    public void setCurrentNewInstance(Class clazz) {
        try {
            EngineScreen instance = (EngineScreen)clazz.newInstance();
            this.setCurrent(instance);
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
            throw new IllegalArgumentException("Could not instantiate " + clazz.getName() + ": InstantiationException");
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            throw new IllegalArgumentException("Could not instantiate " + clazz.getName() + ": IllegalAccessException");
        }
    }

    public final int getWidth() {
        return super.getWidth();
    }

    public final int getHeight() {
        return super.getHeight();
    }

    public int getContentWidth() {
        return super.getWidth();
    }

    public int getContentHeight() {
        return super.getHeight();
    }

    public int getContentX() {
        return 0;
    }

    public int getContentY() {
        return 0;
    }

    private static boolean canUseDeviceControl() {
        try {
            Class.forName("com.nokia.mid.ui.DeviceControl");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public Runnable getEventRunnable(final Event event) {
        return new Runnable(){

            public void run() {
                Engine.this.handleEvent(event);
            }
        };
    }

    public Timer getTimer() {
        return this.timer;
    }
}

