/*
 * Decompiled with CFR 0.152.
 */
package com.am.engine;

import com.am.ashamidlet.AshaMidlet;
import com.am.ashamidlet.Settings;
import com.am.blockapplib.main.BlockerListener;
import com.am.component.Component;
import com.am.engine.Engine;
import com.am.engine.EngineScreen;
import com.am.engine.FreeEngine;
import com.am.resad.Ad;
import com.am.resad.AdOverlay;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

class FreeContainer
implements EngineScreen {
    private static final int BANNER_HEIGHT = 40;
    private Component adOverlay;
    private EngineScreen content;
    private final Engine engine;
    private int contentX = 0;
    private int contentY = 0;
    private int contentWidth;
    private int contentHeight;
    private final int screenHeight;
    private final int screenWidth;
    static /* synthetic */ Class class$com$am$engine$FreeContainer;

    public FreeContainer(AshaMidlet midlet, FreeEngine engine, int screenWidth, int screenHeight) {
        this(midlet, engine, screenWidth, screenHeight, 0, "center", "top");
    }

    public FreeContainer(AshaMidlet midlet, FreeEngine engine, int screenWidth, int screenHeight, int angle, String bannerHAlign, String bannerVAlign) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.initOverlay(midlet, engine, screenWidth, screenHeight, angle, bannerHAlign, bannerVAlign);
        this.content = new SimpleScreen();
        this.engine = engine;
    }

    public void paint(Graphics g2) {
        g2.translate(this.contentX, this.contentY);
        this.content.paint(g2);
        g2.translate(-this.contentX, -this.contentY);
        this.adOverlay.paint(g2);
    }

    public boolean pointerPressed(int x, int y) {
        return this.adOverlay.pointerPressed(x, y) || this.content.pointerPressed(x - this.contentX, y - this.contentY);
    }

    public boolean pointerReleased(int x, int y) {
        return this.adOverlay.pointerReleased(x, y) || this.content.pointerReleased(x - this.contentX, y - this.contentY);
    }

    public boolean pointerDragged(int x, int y) {
        return this.adOverlay.pointerDragged(x, y) || this.content.pointerDragged(x - this.contentX, y - this.contentY);
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public void setContent(EngineScreen content) {
        if (content == null) {
            this.content = new SimpleScreen();
        } else {
            content.setEngine(this.engine);
            this.content = content;
        }
    }

    public EngineScreen getContent() {
        EngineScreen result = this.content;
        if (result instanceof SimpleScreen) {
            return null;
        }
        return result;
    }

    public void setEngine(Engine engine) {
        this.content.setEngine(engine);
    }

    int getContentX() {
        return this.contentX;
    }

    int getContentY() {
        return this.contentY;
    }

    private void initOverlay(AshaMidlet midlet, final FreeEngine engine, final int screenWidth, final int screenHeight, int angle, String bannerHAlign, String bannerVAlign) {
        midlet.blocker.setBlockerListener(new BlockerListener(){

            public void onAppUnlock() {
                Ad.getInstance().setEnabled(false);
                FreeContainer.this.contentX = (FreeContainer.this.contentY = 0);
                FreeContainer.this.contentWidth = screenWidth;
                FreeContainer.this.contentHeight = screenHeight;
                FreeContainer.this.adOverlay = new SimpleScreen();
                engine.handleEvent(FreeEngine.EVENT_PURCHASE);
            }

            public void onBlockerShow() {
                engine.handleEvent(FreeEngine.EVENT_SHOW_BLOCKER);
            }

            public void onBlockerHide() {
                engine.handleEvent(FreeEngine.EVENT_HIDE_BLOCKER);
            }
        });
        boolean showAd = Settings.get("BLOCKER_ENABLED").equals("TRUE") && (class$com$am$engine$FreeContainer == null ? (class$com$am$engine$FreeContainer = FreeContainer.class$("com.am.engine.FreeContainer")) : class$com$am$engine$FreeContainer).getResourceAsStream("/ads/settings.txt") != null && !midlet.blocker.isPurchased();
        System.out.println("Showing ad: " + showAd);
        if (!showAd) {
            this.initOverlayPaid();
        } else {
            this.initAdOverlay(midlet, screenWidth, screenHeight, angle, bannerHAlign, bannerVAlign);
        }
    }

    private void initAdOverlay(MIDlet midlet, int screenWidth, int screenHeight, int angle, String bannerHAlign, String bannerVAlign) {
        AdOverlay ao = new AdOverlay(midlet, screenWidth, screenHeight, true);
        ao.setAngle(angle);
        ao.setAlign(bannerHAlign, bannerVAlign);
        this.contentX = 0;
        this.contentY = 0;
        this.contentWidth = screenWidth;
        this.contentHeight = screenHeight;
        if (angle == 0 || angle == 180) {
            if (screenWidth < screenHeight) {
                if (bannerVAlign.equals("top")) {
                    this.contentY = 40;
                    this.contentHeight -= 40;
                } else if (bannerVAlign.equals("bottom")) {
                    this.contentHeight -= 40;
                }
            }
        } else if (screenWidth > screenHeight) {
            if (bannerHAlign.equals("left")) {
                this.contentX = 40;
                this.contentWidth -= 40;
            } else if (bannerHAlign.equals("right")) {
                this.contentWidth -= 40;
            }
        }
        if (screenWidth < screenHeight) {
            if (bannerVAlign.equals("top") && (angle == 0 || angle == 180)) {
                this.contentY = 40;
            }
        } else if (bannerHAlign.equals("left")) {
            this.contentX = 40;
        }
        ao.reset();
        this.adOverlay = ao;
    }

    public int getX() {
        return 0;
    }

    public int getY() {
        return 0;
    }

    public int getWidth() {
        return this.screenWidth;
    }

    public int getHeight() {
        return this.screenHeight;
    }

    public void setPosition(int x, int y) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void initOverlayPaid() {
        this.adOverlay = new SimpleScreen();
        this.contentWidth = this.screenWidth;
        this.contentHeight = this.screenHeight;
    }

    public void setVisible(boolean visible) {
        throw new UnsupportedOperationException();
    }

    public boolean isVisible() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SimpleScreen
    implements EngineScreen {
        private SimpleScreen() {
        }

        public void paint(Graphics g2) {
        }

        public boolean pointerPressed(int x, int y) {
            return false;
        }

        public boolean pointerReleased(int x, int y) {
            return false;
        }

        public boolean pointerDragged(int x, int y) {
            return false;
        }

        public void setEngine(Engine engine) {
        }

        public int getX() {
            return 0;
        }

        public int getY() {
            return 0;
        }

        public int getWidth() {
            return 0;
        }

        public int getHeight() {
            return 0;
        }

        public void setPosition(int x, int y) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setVisible(boolean visible) {
            throw new UnsupportedOperationException();
        }

        public boolean isVisible() {
            return true;
        }
    }
}

