/*
 * Decompiled with CFR 0.152.
 */
package com.am.resad;

import com.am.resad.Ad;
import com.am.resad.BannerListener;
import com.am.resad.Log;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class BannerSprite
extends Sprite {
    private boolean pressed = false;
    private final int angle;
    private final String alignX;
    private final String alignY;
    private final int screenWidth;
    private final int screenHeight;
    private final BannerListener listener = new Listener();

    BannerSprite(Image image, int angle, String alignX, String alignY, int screenWidth, int screenHeight) {
        super(image);
        if (image.getWidth() % 240 == 0 && image.getHeight() % 40 == 0) {
            this.setImage(image, 240, 40);
        }
        this.angle = angle;
        this.alignX = alignX;
        this.alignY = alignY;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        switch (angle) {
            case 90: {
                this.setTransform(5);
                break;
            }
            case 180: {
                this.setTransform(3);
                break;
            }
            case 270: {
                this.setTransform(6);
            }
        }
        this.resetPosition(angle, alignX, alignY, screenWidth, screenHeight);
    }

    private boolean contains(int x, int y) {
        return x > this.getX() && x < this.getX() + this.getWidth() && y > this.getY() && y < this.getY() + this.getHeight();
    }

    public boolean touchDown(int x, int y) {
        if (this.isVisible() && this.contains(x, y)) {
            this.pressed = true;
            return true;
        }
        return false;
    }

    public boolean touchUp(int x, int y) {
        if (this.pressed) {
            this.pressed = false;
            if (this.isVisible() && this.contains(x, y)) {
                Ad.getInstance().openLink();
                return true;
            }
        }
        return false;
    }

    private int getPositionX(int angle, String alignX, String alignY, int screenWidth) {
        if (alignX.equals("left")) {
            return 0;
        }
        if (alignX.equals("center")) {
            return (screenWidth - this.getWidth()) / 2;
        }
        if (alignX.equals("right")) {
            return screenWidth - this.getWidth();
        }
        throw new IllegalArgumentException("'" + alignX + "' is not valid alignX");
    }

    private int getPositionY(int angle, String alignX, String alignY, int screenHeight) {
        if (alignY.equals("top")) {
            return 0;
        }
        if (alignY.equals("center")) {
            return (screenHeight - this.getHeight()) / 2;
        }
        if (alignY.equals("bottom")) {
            return screenHeight - this.getHeight();
        }
        throw new IllegalArgumentException("\"" + alignY + "\" is not valid alignY");
    }

    private void resetPosition(int angle, String alignX, String alignY, int screenWidth, int screenHeight) {
        int x = this.getPositionX(angle, alignX, alignY, screenWidth);
        int y = this.getPositionY(angle, alignX, alignY, screenHeight);
        this.setPosition(x, y);
    }

    BannerListener getBannerListener() {
        return this.listener;
    }

    private class Listener
    implements BannerListener {
        private Listener() {
        }

        public void imageReceived(Image image, int frameHeight, int frameWidth) {
            Log.d("IMAGE RECEIVED");
            try {
                int prevWidth = BannerSprite.this.getWidth();
                int prevHeight = BannerSprite.this.getHeight();
                BannerSprite.this.setImage(image, frameHeight, frameWidth);
                if (BannerSprite.this.getHeight() != prevHeight || BannerSprite.this.getWidth() != prevWidth) {
                    BannerSprite.this.resetPosition(BannerSprite.this.angle, BannerSprite.this.alignX, BannerSprite.this.alignY, BannerSprite.this.screenWidth, BannerSprite.this.screenHeight);
                }
            }
            catch (Exception e2) {
                Log.e(e2.toString());
            }
        }

        public void setEnabled(boolean enabled) {
            BannerSprite.this.setVisible(enabled);
            if (!enabled) {
                BannerSprite.this.pressed = false;
            }
        }

        public void nextFrame() {
            BannerSprite.this.nextFrame();
        }
    }
}

