/*
 * Decompiled with CFR 0.152.
 */
package com.amediax.SpaceCat_pro.game;

import com.am.activity.tools.SystemProperties;
import com.am.component.Component;
import com.am.component.SpriteButton;
import com.am.engine.Engine;
import com.am.engine.SimpleEngineScreen;
import com.amediax.SpaceCat_pro.Mediator;
import com.amediax.SpaceCat_pro.game.GameResult;
import com.amediax.SpaceCat_pro.game.GameType;
import com.amediax.SpaceCat_pro.game.ai.AI1;
import com.amediax.SpaceCat_pro.game.controller.InputThinker;
import com.amediax.SpaceCat_pro.game.controller.PlayerThinker;
import com.amediax.SpaceCat_pro.game.model.Level;
import com.amediax.SpaceCat_pro.game.view.LevelView;
import com.amediax.SpaceCat_pro.util.CachedSoundManager;
import com.ittop.util.ImageManager;
import javax.microedition.lcdui.Graphics;
import mobi.ittop.util.sound.SoundManager;

public class Game
extends SimpleEngineScreen {
    private static final int CELL_SIZE = 20;
    private static final int LEVEL_MARGINS_X = 40;
    private static final int LEVEL_MARGINS_Y = 40;
    private static final int STARTING_POINT_OFFSET = 4;
    private static final int MAX_PLAYERS = 4;
    private LevelView levelView;
    private Level level;
    private InputThinker[] inputThinkers;
    private boolean gameOver = false;
    private final boolean secondPlayer;
    private final int playersNumber;
    private GameResult result;
    private final SoundManager soundManager;

    public Game() {
        this.playersNumber = 2;
        if (Mediator.currentGameType == GameType.TWO_PLAYERS) {
            this.secondPlayer = true;
        } else if (Mediator.currentGameType == GameType.ONE_PLAYER) {
            this.secondPlayer = false;
        } else {
            throw new IllegalStateException();
        }
        this.soundManager = SoundManager.supportsMixing() ? Mediator.soundManager : this.createSoundManager();
    }

    public void setEngine(Engine engine) {
        super.setEngine(engine);
        this.soundManager.resume();
    }

    protected void init() {
        int levelWidth = this.getWidth() - 40;
        int levelHeight = this.getHeight() - 40;
        this.level = new Level(levelWidth / 20 + 1, levelHeight / 20 + 1);
        int[][] startingPoints = this.getStartingPoints();
        this.initPlayers(startingPoints);
        this.levelView = new LevelView(this.level, this.getWidth(), this.getHeight(), 20, this.soundManager);
        this.addPaintable(this.levelView);
        this.initControllers();
        this.initNavigationButtons(this.getEngine());
    }

    private void initNavigationButtons(Engine engine) {
        if (!SystemProperties.isAsha()) {
            SpriteButton pause = new SpriteButton(ImageManager.getImage("/img/btn/b_pause.png"));
            pause.setPosition(this.getWidth() - pause.getWidth(), 0);
            pause.setAction(engine.getEventRunnable(Engine.EVENT_PAUSE));
            this.addComponent(pause);
        }
    }

    public void paint(Graphics g2) {
        super.paint(g2);
        this.levelView.nextFrame();
        for (int i = 0; i < this.inputThinkers.length; ++i) {
            if (this.inputThinkers[i].isReady()) continue;
            return;
        }
        if (this.levelView.criticalAnimationFinished() && !this.gameOver) {
            this.level.iterate();
            this.checkGameOver();
        } else if (this.gameOver && this.levelView.animationFinished()) {
            this.getEngine().handleEvent(this.result);
        }
    }

    private int[][] getStartingPoints() {
        int[][] startingPoints = new int[][]{{this.level.getColumns() - 1 - 4, this.level.getRows() - 1 - 4}, {4, 4}, {this.level.getColumns() - 1 - 4, 4}, {4, this.level.getRows() - 1 - 4}};
        return startingPoints;
    }

    private void initPlayers(int[][] startingPoints) {
        this.inputThinkers = new InputThinker[this.secondPlayer ? 2 : 1];
        for (int i = 0; i < 2; ++i) {
            PlayerThinker thinker;
            if (i < this.inputThinkers.length) {
                this.inputThinkers[i] = new InputThinker();
                thinker = this.inputThinkers[i];
            } else {
                thinker = new AI1();
            }
            this.level.createPlayer(startingPoints[i][0], startingPoints[i][1], thinker);
        }
    }

    private void initControllers() {
        for (int i = 0; i < this.inputThinkers.length; ++i) {
            Component controller = this.inputThinkers[i].getComponent();
            controller.setPosition(i == 0 ? this.getWidth() - controller.getWidth() : 1, i == 0 ? this.getHeight() - controller.getHeight() : 1);
            this.addComponent(controller);
        }
    }

    private void checkGameOver() {
        if (this.gameOver) {
            return;
        }
        if (this.level.getPlayersNumber() <= 1) {
            this.gameOver = true;
            this.result = this.getGameResult();
        }
    }

    private GameResult getGameResult() {
        if (this.secondPlayer) {
            if (!this.inputThinkers[0].isDead()) {
                return GameResult.TWO_PLAYERS_FIRST_WIN;
            }
            if (!this.inputThinkers[1].isDead()) {
                return GameResult.TWO_PLAYERS_SECOND_WIN;
            }
            return GameResult.TWO_PLAYERS_DRAW;
        }
        if (!this.inputThinkers[0].isDead()) {
            return GameResult.ONE_PLAYER_WIN;
        }
        if (this.level.getPlayersNumber() == 0) {
            return GameResult.ONE_PLAYER_DRAW;
        }
        return GameResult.ONE_PLAYER_LOSS;
    }

    private SoundManager createSoundManager() {
        CachedSoundManager result = new CachedSoundManager();
        result.addToCache("/snd/blast.mp3");
        return result;
    }
}

