/*
 * Decompiled with CFR 0.152.
 */
package com.amediax.SpaceCat_pro.game.ai;

import com.amediax.SpaceCat_pro.game.controller.PlayerThinker;
import com.amediax.SpaceCat_pro.game.model.LevelInfo;
import com.amediax.SpaceCat_pro.game.model.PlayerInfo;
import com.amediax.SpaceCat_pro.game.util.Direction;
import com.amediax.SpaceCat_pro.game.util.Future;
import java.util.Enumeration;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

public class AI1
implements PlayerThinker {
    private final Random rand = new Random();
    private final Timer timer = new Timer();
    private Future resultFuture;

    public void startThinking(final PlayerInfo playerInfo, final LevelInfo levelInfo) {
        final Future future = new Future();
        this.timer.schedule(new TimerTask(){

            public void run() {
                Direction result = AI1.this.calculateDirection(playerInfo, levelInfo);
                future.put(result);
            }
        }, 0L);
        this.resultFuture = future;
    }

    public Direction getDirection(PlayerInfo playerInfo, LevelInfo levelInfo) {
        Direction result = (Direction)this.resultFuture.get();
        return result;
    }

    private static int getMinDistance(int row1, int column1, int row2, int column2) {
        return Math.abs(row2 - row1) + Math.abs(column1 - column2);
    }

    private static int getMinDistance(PlayerInfo p1, PlayerInfo p2) {
        return AI1.getMinDistance(p1.getRow(), p1.getColumn(), p2.getRow(), p2.getColumn());
    }

    private Direction calculateDirection(PlayerInfo playerInfo, LevelInfo levelInfo) {
        int column;
        PlayerInfo enemy = null;
        if ((enemy = this.getClosestEnemy(levelInfo, enemy, playerInfo)) == null) {
            Direction d2 = playerInfo.getDirection();
            if (d2 == Direction.NONE) {
                return playerInfo.getDirection();
            }
            return playerInfo.getDirection();
        }
        Direction bestDirection = this.getBestDirectionToEnemy(playerInfo, levelInfo, enemy);
        if (bestDirection != Direction.NONE) {
            return bestDirection;
        }
        int row = AI1.iterateRow(playerInfo.getRow(), playerInfo.getDirection());
        if (!this.isViablePosition(row, column = AI1.iterateColumn(playerInfo.getColumn(), playerInfo.getDirection()), levelInfo) || (double)this.rand.nextFloat() < 0.05) {
            return this.getRandomDirection(playerInfo, levelInfo);
        }
        return playerInfo.getDirection();
    }

    private static int iterateRow(int row, Direction direction) {
        if (direction == Direction.UP) {
            return --row;
        }
        if (direction == Direction.DOWN) {
            return ++row;
        }
        return row;
    }

    private static int iterateColumn(int column, Direction direction) {
        if (direction == Direction.RIGHT) {
            return ++column;
        }
        if (direction == Direction.LEFT) {
            return --column;
        }
        return column;
    }

    private Direction getBestDirectionToEnemy(PlayerInfo me, LevelInfo levelInfo, PlayerInfo enemy) {
        Direction bestDirection = Direction.NONE;
        int bestDistance = Integer.MAX_VALUE;
        Enumeration directions = Direction.directions();
        while (directions.hasMoreElements()) {
            int distance;
            int column;
            Direction d2 = (Direction)directions.nextElement();
            int row = AI1.iterateRow(me.getRow(), d2);
            if (!this.isViablePosition(row, column = AI1.iterateColumn(me.getColumn(), d2), levelInfo) || (distance = AI1.getMinDistance(enemy.getRow(), enemy.getColumn(), row, column)) >= bestDistance || distance <= 1) continue;
            bestDistance = distance;
            bestDirection = d2;
        }
        return bestDirection;
    }

    private PlayerInfo getClosestEnemy(LevelInfo levelInfo, PlayerInfo enemy, PlayerInfo me) {
        for (int i = 0; i < levelInfo.getPlayersNumber(); ++i) {
            PlayerInfo p = levelInfo.getPlayerInfo(i);
            if (me == p || enemy != null && AI1.getMinDistance(me, enemy) <= AI1.getMinDistance(me, p)) continue;
            enemy = p;
        }
        return enemy;
    }

    private Direction getRandomDirection(PlayerInfo me, LevelInfo levelInfo) {
        Direction result = Direction.NONE;
        int viableDirectionsFound = 0;
        Enumeration directions = Direction.directions();
        while (directions.hasMoreElements()) {
            int column;
            Direction d2 = (Direction)directions.nextElement();
            int row = AI1.iterateRow(me.getRow(), d2);
            if (!this.isViablePosition(row, column = AI1.iterateColumn(me.getColumn(), d2), levelInfo) || this.rand.nextInt(++viableDirectionsFound) != 0) continue;
            result = d2;
        }
        if (result == Direction.NONE) {
            result = me.getDirection();
        }
        return result;
    }

    private boolean isViablePosition(int row, int column, LevelInfo levelInfo) {
        return row >= 0 && row < levelInfo.getRows() && column >= 0 && column < levelInfo.getColumns() && levelInfo.isEmpty(column, row);
    }
}

