/*
 * Decompiled with CFR 0.152.
 */
package com.amediax.SpaceCat_pro.game.model;

import com.amediax.SpaceCat_pro.game.controller.PlayerThinker;
import com.amediax.SpaceCat_pro.game.model.FieldState;
import com.amediax.SpaceCat_pro.game.model.LevelInfo;
import com.amediax.SpaceCat_pro.game.model.Player;
import com.amediax.SpaceCat_pro.game.model.PlayerFieldState;
import com.amediax.SpaceCat_pro.game.model.PlayerInfo;
import com.amediax.SpaceCat_pro.game.util.Direction;
import java.util.Vector;

public class Level
implements LevelInfo {
    private final int columns;
    private final int rows;
    private final FieldState[][] fields;
    private final Vector players = new Vector();
    private boolean prepared;

    public Level(int columns, int rows) {
        this.columns = columns;
        this.rows = rows;
        this.fields = new FieldState[rows][columns];
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                this.fields[row][column] = FieldState.EMPTY;
            }
        }
    }

    public boolean isEmpty(int column, int row) {
        return this.fields[row][column] == FieldState.EMPTY;
    }

    public boolean isPlayer(int column, int row) {
        return this.fields[row][column] instanceof PlayerFieldState;
    }

    public boolean isWall(int column, int row) {
        return this.fields[row][column] == FieldState.WALL;
    }

    public int getPlayersNumber() {
        return this.players.size();
    }

    public PlayerInfo getPlayerInfo(int index) {
        return ((Player)this.players.elementAt(index)).getInfo();
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public PlayerInfo createPlayer(int column, int row, PlayerThinker thinker) {
        if (row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Player player = new Player(column, row, thinker);
        this.players.addElement(player);
        return player;
    }

    private void prepare() {
        for (int i = 0; i < this.getPlayersNumber(); ++i) {
            Player p = this.getPlayer(i);
            p.prepare(this);
        }
        this.prepared = true;
    }

    public void iterate() {
        Player p;
        int i;
        if (!this.prepared) {
            this.prepare();
        }
        for (i = 0; i < this.getPlayersNumber(); ++i) {
            p = this.getPlayer(i);
            p.think(this);
        }
        for (i = 0; i < this.getPlayersNumber(); ++i) {
            p = this.getPlayer(i);
            Direction direction = p.getDirection();
            int row = p.getRow();
            int column = p.getColumn();
            this.fields[row][column] = FieldState.WALL;
            row = Level.iterateRow(row, direction);
            column = Level.iterateColumn(column, direction);
            p.setPosition(column, row);
            if (!this.validCoords(column, row)) {
                column = Math.max(0, Math.min(this.getColumns() - 1, column));
                row = Math.max(0, Math.min(this.getRows() - 1, row));
                p.setPosition(column, row);
                p.die();
                continue;
            }
            if (this.isWall(column, row)) {
                p.die();
                continue;
            }
            if (this.isPlayer(column, row)) {
                Player p2 = this.getPlayer(column, row);
                if (this.players.indexOf(p2) < i) {
                    p2.die();
                    p.die();
                    continue;
                }
                p.die();
                continue;
            }
            this.fields[row][column] = new PlayerFieldState(p);
        }
        for (i = this.getPlayersNumber() - 1; i >= 0; --i) {
            p = this.getPlayer(i);
            if (!p.isDead()) continue;
            this.players.removeElementAt(i);
        }
        this.prepare();
    }

    private boolean validCoords(int column, int row) {
        return column >= 0 && column < this.columns && row >= 0 && row < this.rows;
    }

    private Player getPlayer(int column, int row) {
        return ((PlayerFieldState)this.fields[row][column]).getPlayer();
    }

    private Player getPlayer(int index) {
        return (Player)this.players.elementAt(index);
    }

    private static int iterateColumn(int column, Direction direction) {
        if (direction == Direction.LEFT) {
            return --column;
        }
        if (direction == Direction.RIGHT) {
            return ++column;
        }
        return column;
    }

    private static int iterateRow(int row, Direction direction) {
        if (direction == Direction.UP) {
            return --row;
        }
        if (direction == Direction.DOWN) {
            return ++row;
        }
        return row;
    }
}

