/*
 * Decompiled with CFR 0.152.
 */
package com.amediax.SpaceCat_pro.game.model;

import com.amediax.SpaceCat_pro.game.controller.PlayerThinker;
import com.amediax.SpaceCat_pro.game.model.LevelInfo;
import com.amediax.SpaceCat_pro.game.model.PlayerInfo;
import com.amediax.SpaceCat_pro.game.util.Direction;

final class Player
implements PlayerInfo {
    private int column;
    private int row;
    private boolean dead;
    private Direction direction = Direction.NONE;
    private final PlayerThinker thinker;

    public Player(int column, int row, PlayerThinker thinker) {
        this.setPosition(column, row);
        this.thinker = thinker;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public void think(LevelInfo levelInfo) {
        Direction nextDirection = this.thinker.getDirection(this, levelInfo);
        if (nextDirection == Direction.NONE) {
            throw new IllegalStateException();
        }
        this.setDirection(nextDirection);
    }

    public void prepare(LevelInfo levelInfo) {
        this.thinker.startThinking(this, levelInfo);
    }

    public PlayerInfo getInfo() {
        return this;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setPosition(int column, int row) {
        this.column = column;
        this.row = row;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void die() {
        this.dead = true;
    }
}

