/*
 * Decompiled with CFR 0.152.
 */
package com.amediax.SpaceCat_pro.game.util;

import java.util.Enumeration;

public final class Direction {
    public static final Direction NONE = new Direction(-1, "None");
    public static final Direction RIGHT = new Direction(0, "Right");
    public static final Direction UP = new Direction(1, "Up");
    public static final Direction LEFT = new Direction(2, "Left");
    public static final Direction DOWN = new Direction(3, "Down");
    private static final int NUM_DIRECTIONS = 4;
    private final String name;
    private final int index;

    private Direction(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Direction(" + this.name + ')';
    }

    private static Direction byIndex(int index) {
        switch (index) {
            case -1: {
                return NONE;
            }
            case 0: {
                return RIGHT;
            }
            case 1: {
                return UP;
            }
            case 2: {
                return LEFT;
            }
            case 3: {
                return DOWN;
            }
        }
        throw new IllegalArgumentException();
    }

    private Direction turn(int positions) {
        if (this == NONE) {
            return this;
        }
        return Direction.byIndex((this.index + positions) % 4);
    }

    public Direction opposite() {
        return this.turn(2);
    }

    public Direction clockwise() {
        return this.turn(3);
    }

    public Direction counterClockwise() {
        return this.turn(1);
    }

    public static Enumeration directions() {
        return new Enumeration(){
            int index = 0;

            public boolean hasMoreElements() {
                return this.index < 4;
            }

            public Object nextElement() {
                return Direction.byIndex(this.index++);
            }
        };
    }
}

