/*
 * Decompiled with CFR 0.152.
 */
package com.amediax.SpaceCat_pro.game.util.dpad;

import com.am.component.Container;
import com.am.component.PaintableSprite;
import com.amediax.SpaceCat_pro.game.util.Direction;
import com.amediax.SpaceCat_pro.game.util.dpad.TwoStateButton;
import com.ittop.util.ImageManager;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public class DPad
extends Container {
    private Direction selectedDirection = Direction.NONE;
    private final Hashtable buttons = new Hashtable();

    public DPad() {
        PaintableSprite bg = new PaintableSprite(ImageManager.getImage("/img/btn/dpad/cross_bg.png"));
        this.setSize(bg.getWidth(), bg.getHeight());
        this.addPaintable(bg);
        this.initDirectionButton(Direction.LEFT);
        this.initDirectionButton(Direction.RIGHT);
        this.initDirectionButton(Direction.UP);
        this.initDirectionButton(Direction.DOWN);
    }

    public Direction getSelectedDirection() {
        return this.selectedDirection;
    }

    public void resetSelection() {
        this.setSelectedDirection(Direction.NONE);
    }

    public void setDirectionEnabled(Direction direction, boolean enabled) {
        TwoStateButton button = (TwoStateButton)this.buttons.get(direction);
        button.setVisible(enabled);
    }

    public boolean isDirectionEnabled(Direction direction) {
        return ((TwoStateButton)this.buttons.get(direction)).isVisible();
    }

    private void initDirectionButton(final Direction direction) {
        String path = "/img/btn/dpad/cross_" + direction.getName().toLowerCase() + ".png";
        Image image = ImageManager.getImage(path);
        TwoStateButton button = new TwoStateButton(image);
        button.setAction(new Runnable(){

            public void run() {
                DPad.this.setSelectedDirection(direction);
            }
        });
        if (direction == Direction.LEFT) {
            button.setPosition(0, (this.getHeight() - button.getHeight()) / 2);
        } else if (direction == Direction.RIGHT) {
            button.setPosition(this.getWidth() - button.getWidth(), (this.getHeight() - button.getHeight()) / 2);
        } else if (direction == Direction.UP) {
            button.setPosition((this.getWidth() - button.getWidth()) / 2, 0);
        } else if (direction == Direction.DOWN) {
            button.setPosition((this.getWidth() - button.getWidth()) / 2, this.getHeight() - button.getHeight());
        }
        this.buttons.put(direction, button);
        this.addComponent(button);
    }

    public void setSelectedDirection(Direction direction) {
        Enumeration e2 = this.buttons.keys();
        while (e2.hasMoreElements()) {
            Direction key = (Direction)e2.nextElement();
            TwoStateButton button = (TwoStateButton)this.buttons.get(key);
            button.setSelected(key == direction);
        }
        this.selectedDirection = direction;
    }
}

