/*
 * Decompiled with CFR 0.152.
 */
package com.amediax.SpaceCat_pro.game.view;

import com.am.activity.tools.ImageHelper;
import com.am.component.Container;
import com.am.component.PaintableSprite;
import com.amediax.SpaceCat_pro.game.model.LevelInfo;
import com.amediax.SpaceCat_pro.game.model.PlayerInfo;
import com.amediax.SpaceCat_pro.game.util.CoordinateTransformer;
import com.amediax.SpaceCat_pro.game.view.Animated;
import com.amediax.SpaceCat_pro.game.view.ExplosionView;
import com.amediax.SpaceCat_pro.game.view.PlayerView;
import com.ittop.util.ImageManager;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mobi.ittop.util.sound.SoundManager;

public final class LevelView
extends Container
implements Animated {
    private final Vector animatedItems = new Vector();
    private final Vector players = new Vector();
    private final Container bgContainer;
    private final SoundManager soundManager;

    public LevelView(LevelInfo info, int width, int height, int cellSize, SoundManager soundManager) {
        this.soundManager = soundManager;
        this.setSize(width, height);
        int offsetX = (width - (info.getColumns() - 1) * cellSize) / 2;
        int offsetY = (height - (info.getRows() - 1) * cellSize) / 2;
        CoordinateTransformer transformer = new CoordinateTransformer(offsetX, offsetY, cellSize, cellSize);
        this.bgContainer = this.createBgContainer(info, transformer);
        this.addPaintable(this.bgContainer);
        int n = info.getPlayersNumber();
        for (int i = 0; i < n; ++i) {
            PlayerInfo pi = info.getPlayerInfo(i);
            PlayerView pv = PlayerView.createPlayerView(pi, i, transformer);
            this.addPlayerView(pv);
        }
    }

    public void nextFrame() {
        for (int i = 0; i < this.animatedItems.size(); ++i) {
            Animated a2 = (Animated)this.animatedItems.elementAt(i);
            a2.nextFrame();
        }
    }

    public boolean criticalAnimationFinished() {
        int i;
        for (i = 0; i < this.animatedItems.size(); ++i) {
            Animated a2 = (Animated)this.animatedItems.elementAt(i);
            if (a2.criticalAnimationFinished()) continue;
            return false;
        }
        for (i = this.players.size() - 1; i >= 0; --i) {
            PlayerView p = (PlayerView)this.players.elementAt(i);
            if (!p.isDead()) continue;
            this.removePlayerView(p);
            this.createExplosion(p);
        }
        return true;
    }

    public boolean animationFinished() {
        for (int i = 0; i < this.animatedItems.size(); ++i) {
            Animated a2 = (Animated)this.animatedItems.elementAt(i);
            if (a2.animationFinished()) continue;
            return false;
        }
        return true;
    }

    private Container createBgContainer(LevelInfo info, CoordinateTransformer transformer) {
        Image image = ImageManager.getImage("/img/back.jpg");
        if (image.getWidth() < this.getWidth() || image.getHeight() < this.getHeight()) {
            image = ImageHelper.scaleImage(image, this.getWidth(), this.getHeight());
        }
        final Image bgImage = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        final Graphics graphics = bgImage.getGraphics();
        graphics.drawImage(image, 0, 0, 0);
        this.paintGrid(info, graphics, transformer);
        return new Container(){
            final PaintableSprite bgSprite;
            {
                this.bgSprite = new PaintableSprite(bgImage);
            }

            public void paint(Graphics g2) {
                super.paint(graphics);
                this.bgSprite.paint(g2);
            }
        };
    }

    private void removePlayerView(PlayerView p) {
        this.players.removeElement(p);
        this.removePaintable(p);
        this.animatedItems.removeElement(p);
        this.bgContainer.removePaintable(p.getTrail());
    }

    private void addPlayerView(PlayerView pv) {
        this.players.addElement(pv);
        this.addPaintable(pv);
        this.bgContainer.addPaintable(pv.getTrail());
        this.animatedItems.addElement(pv);
    }

    private void createExplosion(PlayerView p) {
        ExplosionView e2 = new ExplosionView();
        e2.setPosition(p.getX() + (p.getWidth() - e2.getWidth()) / 2, p.getY() + (p.getHeight() - e2.getHeight()) / 2);
        this.addPaintable(e2);
        this.animatedItems.addElement(e2);
        this.soundManager.play("/snd/blast.mp3");
    }

    private void paintGrid(LevelInfo info, Graphics graphics, CoordinateTransformer transformer) {
        graphics.setColor(0xFFFFFF);
        for (int row = 0; row < info.getRows(); ++row) {
            graphics.drawLine(transformer.transformX(0), transformer.transformY(row), transformer.transformX(info.getColumns() - 1), transformer.transformY(row));
        }
        for (int column = 0; column < info.getColumns(); ++column) {
            graphics.drawLine(transformer.transformX(column), transformer.transformY(0), transformer.transformX(column), transformer.transformY(info.getRows() - 1));
        }
    }
}

