/*
 * Decompiled with CFR 0.152.
 */
package com.amediax.SpaceCat_pro.game.view;

import com.am.component.Paintable;
import com.am.component.PaintableSprite;
import com.amediax.SpaceCat_pro.game.model.PlayerInfo;
import com.amediax.SpaceCat_pro.game.util.CoordinateTransformer;
import com.amediax.SpaceCat_pro.game.util.Direction;
import com.amediax.SpaceCat_pro.game.view.Animated;
import com.ittop.util.ImageManager;
import javax.microedition.lcdui.Image;

public final class PlayerView
extends PaintableSprite
implements Animated {
    private static final int PLAYER_FRAME_COUNT = 2;
    private static final int SPEED = 4;
    private static final int FRAME_CHANGE_PERIOD = 3;
    public static final int NUM_PLAYER_IMAGES = 2;
    private final PaintableSprite trail;
    private final PlayerInfo info;
    private final CoordinateTransformer transformer;
    private Direction direction;
    private int frameChangeCountdown = 3;

    private PlayerView(PlayerInfo info, Image playerImage, Image trailImage, CoordinateTransformer transformer) {
        super(playerImage);
        this.info = info;
        this.transformer = transformer;
        this.trail = new PaintableSprite(trailImage);
        this.setPosition(this.getTargetX(), this.getTargetY());
    }

    private PlayerView(PlayerInfo info, Image playerImage, int frameWidth, int frameHeight, Image trailImage, CoordinateTransformer transformer) {
        super(playerImage, frameWidth, frameHeight);
        this.info = info;
        this.transformer = transformer;
        this.trail = new PaintableSprite(trailImage);
        this.setPosition(this.getTargetX(), this.getTargetY());
    }

    private void setDirection(Direction direction) {
        if (this.direction == direction) {
            return;
        }
        int x = this.getCenterX();
        int y = this.getCenterY();
        int transform = PlayerView.getTransform(direction);
        this.setTransform(transform);
        this.trail.setTransform(transform);
        this.setPosition(x - this.getWidth() / 2, y - this.getWidth() / 2);
        this.direction = direction;
    }

    public void setPosition(int x, int y) {
        super.setPosition(x, y);
        this.trail.setPosition(x + (this.getWidth() - this.trail.getWidth()) / 2, y + (this.getHeight() - this.trail.getHeight()) / 2);
    }

    private static int getTransform(Direction direction) {
        if (direction == Direction.RIGHT || direction == Direction.NONE) {
            return 0;
        }
        if (direction == Direction.LEFT) {
            return 2;
        }
        if (direction == Direction.UP) {
            return 6;
        }
        if (direction == Direction.DOWN) {
            return 5;
        }
        throw new IllegalArgumentException();
    }

    private int getCenterX() {
        return this.getX() + this.getWidth() / 2;
    }

    private int getCenterY() {
        return this.getY() + this.getHeight() / 2;
    }

    public Paintable getTrail() {
        return this.trail;
    }

    public boolean animationFinished() {
        return this.getTargetX() == this.getX() && this.getTargetY() == this.getY();
    }

    public boolean criticalAnimationFinished() {
        return this.animationFinished();
    }

    public void nextFrame() {
        if (--this.frameChangeCountdown <= 0) {
            super.nextFrame();
            this.frameChangeCountdown = 3;
        }
        int targetX = this.getTargetX();
        int targetY = this.getTargetY();
        int x = PlayerView.iterateCoordinate(this.getX(), targetX);
        int y = PlayerView.iterateCoordinate(this.getY(), targetY);
        this.setPosition(x, y);
        this.setDirection(this.info.getDirection());
    }

    public boolean isDead() {
        return this.info.isDead();
    }

    private int getTargetX() {
        return this.transformer.transformX(this.info.getColumn()) - this.getWidth() / 2;
    }

    private int getTargetY() {
        return this.transformer.transformY(this.info.getRow()) - this.getHeight() / 2;
    }

    private static int iterateCoordinate(int coord, int targetCoord) {
        if (coord < targetCoord) {
            return Math.min(targetCoord, coord + 4);
        }
        return Math.max(targetCoord, coord - 4);
    }

    public static final PlayerView createPlayerView(PlayerInfo info, int index, CoordinateTransformer transformer) {
        String playerPath = "/img/game/player_" + (index %= 2) + ".png";
        String trailPath = "/img/game/trail_" + index + ".png";
        Image playerImage = ImageManager.getImage(playerPath);
        Image trailImage = ImageManager.getImage(trailPath);
        return new PlayerView(info, playerImage, playerImage.getWidth() / 2, playerImage.getHeight(), trailImage, transformer);
    }
}

