/*
 * Decompiled with CFR 0.152.
 */
package com.amediax.SpaceCat_pro.menu;

import com.am.activity.components.NewButton;
import com.am.activity.tools.SystemProperties;
import com.am.engine.Engine;
import com.amediax.SpaceCat_pro.Res;
import com.amediax.SpaceCat_pro.menu.Menu;
import com.ittop.util.ImageManager;
import com.ittop.util.ScrollText;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;

public class InfoMenu
extends Menu {
    public static final int TOP_MARGIN = 5;
    public static final int RIGHT_MARGIN = 5;
    public static final int BOTTOM_MARGIN = SystemProperties.isAsha() ? 5 : 45;
    public static final int LEFT_MARGIN = 5;
    private ScrollText scrollText;
    private final String text;

    public InfoMenu(String text) {
        this.text = text;
    }

    public void initResources() {
        Image image;
        Font font = Res.FONT_INFO;
        this.scrollText = new ScrollText(font, this.getActivityWidth() - 5 - 5, this.getActivityHeight() - 5 - BOTTOM_MARGIN, this.text);
        this.scrollText.setPosition(5, 5);
        this.addTextField(this.scrollText);
        this.setTextColor(0xFFFFFF);
        if (!SystemProperties.isAsha()) {
            image = ImageManager.getImage("/img/btn/b_menu.png");
            NewButton toMenu = NewButton.createButtonWithImage(this, image);
            toMenu.setPosition(this.getActivityWidth() - toMenu.getWidth(), this.getActivityHeight() - toMenu.getHeight());
            this.registerEvent(toMenu, Engine.EVENT_MAIN_MENU);
        }
        image = ImageManager.getImage("/img/back.jpg");
        Sprite background = new Sprite(image);
        background.setPosition(0, (this.getActivityHeight() - background.getHeight()) / 2);
        this.append((Layer)background);
    }

    public void setTextColor(int color) {
        this.scrollText.setScrollColor(color);
        this.scrollText.setTextColor(color);
    }

    public void setScrollTextPosition(int x, int y) {
        this.scrollText.setPosition(x, y);
    }

    public void setScrollTextWidth(int width, int height) {
        this.scrollText.setSize(width, height);
    }

    public void paint(Graphics g2, int x, int y) {
        super.paint(g2, x, y);
        this.scrollText.setPosition(this.scrollText.getX() + x, this.scrollText.getY() + y);
        this.scrollText.paint(g2);
        this.scrollText.setPosition(this.scrollText.getX() - x, this.scrollText.getY() - y);
    }
}

