/*
 * Decompiled with CFR 0.152.
 */
package com.amediax.SpaceCat_pro.menu;

import com.am.activity.components.NewButton;
import com.am.activity.tools.SystemProperties;
import com.am.engine.Engine;
import com.amediax.SpaceCat_pro.Res;
import com.amediax.SpaceCat_pro.game.GameResult;
import com.amediax.SpaceCat_pro.menu.Menu;
import com.amediax.SpaceCat_pro.menu.SoundButton;
import com.ittop.util.ImageManager;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;
import mobi.ittop.util.sound.SoundManager;

public class WinMenu
extends Menu {
    private final GameResult result;

    public WinMenu(GameResult result) {
        this.result = result;
    }

    public void initResources() {
        this.initButtons();
        this.initLabels();
        Image image = ImageManager.getImage("/img/back.jpg");
        Sprite background = new Sprite(image);
        background.setPosition(0, (this.getActivityHeight() - background.getHeight()) / 2);
        this.append((Layer)background);
        if (this.result == GameResult.ONE_PLAYER_WIN || this.result == GameResult.TWO_PLAYERS_FIRST_WIN || this.result == GameResult.TWO_PLAYERS_SECOND_WIN) {
            SoundManager.getActive().play("/snd/win.mp3");
        } else {
            SoundManager.getActive().play("/snd/lose.mp3");
        }
    }

    private void initLabelOnePlayer(String message) {
        Sprite label = this.createLabel(message, Res.FONT_GAMEOVER, 0xFFFFFF);
        label.setPosition((this.getWidth() - label.getWidth()) / 2, this.getHeight() / 3);
        this.append((Layer)label);
    }

    private void initLabelsTwoPlayers(String message1, String message2) {
        Sprite label1 = this.createLabel(message1, Res.FONT_GAMEOVER, 0xFFFFFF);
        label1.setPosition((this.getWidth() - label1.getWidth()) / 2, 2 * this.getHeight() / 3);
        this.append((Layer)label1);
        Sprite label2 = this.createLabel(message2, Res.FONT_GAMEOVER, 0xFFFFFF);
        label2.setTransform(3);
        label2.setPosition((this.getWidth() - label2.getWidth()) / 2, this.getHeight() / 3 - label2.getHeight());
        this.append((Layer)label2);
    }

    private Sprite createLabel(String text, Font font, int textColor) {
        Image mask = Image.createImage((int)font.stringWidth(text), (int)font.getHeight());
        Graphics g2 = mask.getGraphics();
        g2.setColor(0);
        g2.setFont(font);
        g2.drawString(text, 0, 0, 20);
        int[] rgb = new int[mask.getWidth() * mask.getHeight()];
        mask.getRGB(rgb, 0, mask.getWidth(), 0, 0, mask.getWidth(), mask.getHeight());
        for (int i = 0; i < rgb.length; ++i) {
            int color = rgb[i];
            int bColor = color & 0xFF;
            int alpha = 255 - bColor;
            rgb[i] = color = alpha << 24 | textColor;
        }
        Image image = Image.createRGBImage((int[])rgb, (int)mask.getWidth(), (int)mask.getHeight(), (boolean)true);
        return new Sprite(image);
    }

    public void refreshResources() {
    }

    private void initLabels() throws IllegalStateException {
        if (this.result == GameResult.ONE_PLAYER_WIN) {
            this.initLabelOnePlayer(Res.TEXT_WIN);
        } else if (this.result == GameResult.ONE_PLAYER_LOSS) {
            this.initLabelOnePlayer(Res.TEXT_LOSS);
        } else if (this.result == GameResult.ONE_PLAYER_DRAW) {
            this.initLabelOnePlayer(Res.TEXT_DRAW);
        } else if (this.result == GameResult.TWO_PLAYERS_FIRST_WIN) {
            this.initLabelsTwoPlayers(Res.TEXT_WIN, Res.TEXT_LOSS);
        } else if (this.result == GameResult.TWO_PLAYERS_SECOND_WIN) {
            this.initLabelsTwoPlayers(Res.TEXT_LOSS, Res.TEXT_WIN);
        } else if (this.result == GameResult.TWO_PLAYERS_DRAW) {
            this.initLabelsTwoPlayers(Res.TEXT_DRAW, Res.TEXT_DRAW);
        } else {
            throw new IllegalStateException();
        }
    }

    private void initButtons() {
        SoundButton mute = new SoundButton(this);
        this.addButton(mute);
        mute.setPosition(this.getActivityWidth() - mute.getWidth(), 0);
        this.registerEvent(mute, Engine.EVENT_MUTE);
        Image image = ImageManager.getImage("/img/btn/b_replay.png");
        NewButton restart = NewButton.createButtonWithImage(this, image);
        this.addButton(restart);
        this.registerEvent(restart, Engine.EVENT_RESTART);
        if (SystemProperties.isAsha()) {
            restart.setPosition((this.getActivityWidth() - restart.getWidth()) / 2, this.getActivityHeight() - restart.getHeight());
        } else {
            restart.setPosition(0, this.getActivityHeight() - restart.getHeight());
            image = ImageManager.getImage("/img/btn/b_menu.png");
            NewButton toMenu = NewButton.createButtonWithImage(this, image);
            toMenu.setPosition(this.getActivityWidth() - toMenu.getWidth(), this.getActivityHeight() - toMenu.getHeight());
            this.addButton(toMenu);
            this.registerEvent(toMenu, Engine.EVENT_MAIN_MENU);
        }
    }
}

