/*
 * Decompiled with CFR 0.152.
 */
package com.amediax.SpaceCat_pro.util;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import mobi.ittop.util.sound.SoundManager;

public class CachedSoundManager
extends SoundManager {
    private static final Object NULL = new Object();
    private Hashtable cache = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToCache(String path) {
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            if (this.cache.containsKey(path)) {
                return true;
            }
            Object value = super.isActive() ? this.createPlayer(path) : NULL;
            this.cache.put(path, value);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFromCache(String path) {
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            return this.cache.remove(path) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            this.cache.clear();
        }
    }

    private Object createPlayer(String path) {
        try {
            InputStream in = this.getClass().getResourceAsStream(path);
            if (in == null) {
                return NULL;
            }
            Player result = Manager.createPlayer((InputStream)in, (String)SoundManager.getMimeType(path));
            result.prefetch();
            return result;
        }
        catch (Throwable t) {
            System.err.println("Could not create player for " + path);
            t.printStackTrace();
            return NULL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pause() {
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            Enumeration ks = this.cache.keys();
            while (ks.hasMoreElements()) {
                String key = (String)ks.nextElement();
                Object value = this.cache.get(key);
                if (value != NULL) {
                    Player p = (Player)value;
                    p.close();
                }
                this.cache.put(key, NULL);
            }
        }
        super.pause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resume() {
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            Enumeration ks = this.cache.keys();
            while (ks.hasMoreElements()) {
                String key = (String)ks.nextElement();
                Object value = this.cache.get(key);
                if (value != NULL) continue;
                this.cache.put(key, this.createPlayer(key));
            }
        }
        super.resume();
    }

    public void play(String path) {
        if (!this.tryPlayCached(path)) {
            super.play(path);
        }
    }

    public void play(String path, String mimeType) {
        if (!this.tryPlayCached(path)) {
            super.play(path, mimeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryPlayCached(String path) {
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            try {
                if (!this.isActive() || SoundManager.isMute()) {
                    return true;
                }
                if (this.cache.contains(path)) {
                    Player p;
                    Object value = this.cache.get(path);
                    if (value != NULL && (p = (Player)value).getState() != 400) {
                        p.setMediaTime(-1L);
                        p.start();
                    }
                    return true;
                }
            }
            catch (Throwable t) {
                System.err.println("Unable to play " + path);
                t.printStackTrace();
            }
        }
        return false;
    }
}

