/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.util;

import com.ittop.util.Comparer;
import java.util.Enumeration;
import java.util.Random;

public class Arrays {
    private static Random rand = new Random();

    private Arrays() {
    }

    public static String mkString(Object[] array, String start, String separator, String end) {
        StringBuffer buf = new StringBuffer(start);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(array[i]);
        }
        buf.append(end);
        return buf.toString();
    }

    public static String mkString(Object[] array, String separator) {
        return Arrays.mkString(array, "", separator, "");
    }

    public static String toString(Object[] array) {
        return Arrays.mkString(array, "[", ",", "]");
    }

    public static void shuffle(Object[] array, int start, int end) {
        for (int i = end - start - 1; i > 0; --i) {
            int j = rand.nextInt(i + 1);
            Arrays.swap(array, i + start, j + start);
        }
    }

    public static void shuffle(Object[] array, int start) {
        Arrays.shuffle(array, start, array.length);
    }

    public static void shuffle(Object[] array) {
        Arrays.shuffle(array, 0);
    }

    public static int shuffleWithMark(Object[] array, int markedIndex) {
        for (int i = array.length - 1; i > 0; --i) {
            int j = rand.nextInt(i + 1);
            Arrays.swap(array, i, j);
            if (markedIndex == i) {
                markedIndex = j;
                continue;
            }
            if (markedIndex != j) continue;
            markedIndex = i;
        }
        return markedIndex;
    }

    private static void swap(Object[] array, int a2, int b2) {
        Object t = array[a2];
        array[a2] = array[b2];
        array[b2] = t;
    }

    public static void copyInto(Object[] source, Object[] target) {
        int n = source.length;
        for (int i = 0; i < n; ++i) {
            target[i] = source[i];
        }
    }

    public static void copyInto(Enumeration source, Object[] target) {
        int i = 0;
        while (source.hasMoreElements()) {
            target[i] = source.nextElement();
            ++i;
        }
    }

    public static boolean contains(Object[] haystack, Object needle) {
        for (int i = 0; i < haystack.length; ++i) {
            if (needle != haystack[i]) continue;
            return true;
        }
        return false;
    }

    private static void sort(Object[] array, int low, int high, Comparer cmp) {
        int curLow = low;
        int curHigh = high;
        if (curLow >= curHigh) {
            return;
        }
        if (curLow == curHigh - 1) {
            if (cmp.greaterThan(array[curLow], array[curHigh])) {
                Arrays.swap(array, curLow, curHigh);
            }
            return;
        }
        int pivotIndex = (curLow + curHigh) / 2;
        Object pivot = array[pivotIndex];
        array[pivotIndex] = array[curHigh];
        array[curHigh] = pivot;
        --curHigh;
        while (curLow < curHigh) {
            while (!cmp.greaterThan(array[curLow], pivot) && curLow < curHigh) {
                ++curLow;
            }
            while (!cmp.greaterThan(pivot, array[curHigh]) && curLow < curHigh) {
                --curHigh;
            }
            if (curLow >= curHigh) continue;
            Arrays.swap(array, curLow, curHigh);
        }
        array[high] = array[curHigh];
        array[curHigh] = pivot;
        Arrays.sort(array, low, curLow - 1, cmp);
        Arrays.sort(array, curHigh + 1, high, cmp);
    }

    public static void sort(Object[] array, Comparer comparer) {
        Arrays.sort(array, 0, array.length - 1, comparer);
    }
}

