/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.util;

import com.ittop.util.UnknownImageFormat;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public final class ImageManager {
    private static Hashtable images = new Hashtable();
    static /* synthetic */ Class class$com$ittop$util$ImageManager;

    private ImageManager() {
    }

    public static Image getTransparentImage() {
        return Image.createRGBImage((int[])new int[]{0}, (int)1, (int)1, (boolean)true);
    }

    public static Image scaleImageToHeight(Image image, int height) {
        return ImageManager.scaleImage(image, (int)((float)image.getWidth() * (float)height / (float)image.getHeight()), height);
    }

    public static Image scaleImage(Image original, int newWidth, int newHeight) {
        int[] rawInput = new int[original.getHeight() * original.getWidth()];
        original.getRGB(rawInput, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int YD = original.getHeight() / newHeight * original.getWidth() - original.getWidth();
        int YR = original.getHeight() % newHeight;
        int XD = original.getWidth() / newWidth;
        int XR = original.getWidth() % newWidth;
        int outOffset = 0;
        int inOffset = 0;
        int YE = 0;
        for (int y = newHeight; y > 0; --y) {
            int XE = 0;
            for (int x = newWidth; x > 0; --x) {
                rawOutput[outOffset++] = rawInput[inOffset];
                inOffset += XD;
                if ((XE += XR) < newWidth) continue;
                XE -= newWidth;
                ++inOffset;
            }
            inOffset += YD;
            if ((YE += YR) < newHeight) continue;
            YE -= newHeight;
            inOffset += original.getWidth();
        }
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)false);
    }

    public static Image getImage(String path) {
        Image image;
        WeakReference<Image> ref = (WeakReference<Image>)images.get(path);
        if (ref != null && (image = (Image)ref.get()) != null) {
            return image;
        }
        try {
            image = Image.createImage((String)path);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Can't create image: " + path);
        }
        ref = new WeakReference<Image>(image);
        images.put(path, ref);
        return image;
    }

    public static Image tryGetImage(String path) {
        Image image;
        WeakReference<Image> ref = (WeakReference<Image>)images.get(path);
        if (ref != null && (image = (Image)ref.get()) != null) {
            return image;
        }
        InputStream in = (class$com$ittop$util$ImageManager == null ? (class$com$ittop$util$ImageManager = ImageManager.class$("com.ittop.util.ImageManager")) : class$com$ittop$util$ImageManager).getResourceAsStream(path);
        if (in == null) {
            return null;
        }
        try {
            image = Image.createImage((InputStream)in);
        }
        catch (IOException ioe) {
            throw new UnknownImageFormat("Unknown image format: " + path);
        }
        ref = new WeakReference<Image>(image);
        images.put(path, ref);
        return image;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

