/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.util;

import com.ittop.util.Files;
import com.ittop.util.Strings;
import com.ittop.util.serialization.HashtableSerializer;
import com.ittop.util.serialization.Serializer;
import com.ittop.util.serialization.StringSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class Properties {
    private final Hashtable table;

    public Properties() {
        this(new Hashtable());
    }

    private Properties(Hashtable table) {
        this.table = table;
    }

    public Properties(String path) throws IOException {
        this();
        String rawData = Files.readUTFResource(path);
        String[] lines = Strings.split(rawData, "\n");
        for (int i = 0; i < lines.length; ++i) {
            String value;
            int pos;
            String line = Strings.trimStart(lines[i]);
            if (line.startsWith("#") || line.startsWith("!")) continue;
            if (line.endsWith("\r")) {
                line = line.substring(0, line.length() - 1);
            }
            if ((pos = line.indexOf(61)) == -1) {
                if (line.trim().length() <= 0) continue;
                throw new IOException("Error on line #" + i + " in " + path + ": \"" + line + "\"");
            }
            String key = line.substring(0, pos);
            String prev = this.table.put(key, value = line.substring(pos + 1));
            if (prev == null) continue;
            throw new IOException("Error on line #" + i + " in " + path + ": key " + key + "already exists");
        }
    }

    public Enumeration keys() {
        return this.table.keys();
    }

    public int getInt(String key) {
        return this.getInt(key, 10);
    }

    public int getIntOrElse(String key, int defaultValue) {
        return this.getIntOrElse(key, 10, defaultValue);
    }

    public int getInt(String key, int radix) {
        String value = this.get(key);
        return this.parseIntTranslateException(value, radix, key);
    }

    public int getIntOrElse(String key, int radix, int defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return this.parseIntTranslateException(value, radix, key);
    }

    public boolean getBoolean(String key) {
        return Properties.parseBoolean(this.get(key));
    }

    public boolean getBooleanOrElse(String key, boolean defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Properties.parseBoolean(value);
    }

    public String tryGet(String key) {
        return (String)this.table.get(key);
    }

    public String get(String key) {
        String result = this.tryGet(key);
        if (result == null) {
            throw new IllegalArgumentException("Failed getting value for key " + key);
        }
        return result;
    }

    public String getOrElse(String key, String defaultValue) {
        String result = this.tryGet(key);
        return result == null ? defaultValue : result;
    }

    public Properties merge(Properties that, boolean override) {
        String value;
        String key;
        Hashtable<String, String> newTable = new Hashtable<String, String>();
        Enumeration e2 = this.table.keys();
        while (e2.hasMoreElements()) {
            key = (String)e2.nextElement();
            value = this.get(key);
            newTable.put(key, value);
        }
        e2 = that.table.keys();
        while (e2.hasMoreElements()) {
            key = (String)e2.nextElement();
            value = that.get(key);
            if (!override) {
                value = this.getOrElse(key, value);
            }
            newTable.put(key, value);
        }
        return new Properties(newTable);
    }

    public Properties merge(Properties that) {
        return this.merge(that, true);
    }

    private static boolean parseBoolean(String value) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("\"" + value + "\" is not a valid boolean representation");
    }

    private int parseIntTranslateException(String value, int radix, String key) throws NumberFormatException {
        try {
            return Integer.parseInt(value.trim(), radix);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException("\"" + value + "\" is not a valid integer with base " + radix + " for property \"" + key + "\"");
        }
    }

    public static Serializer getSerializer() {
        StringSerializer ss = new StringSerializer();
        final HashtableSerializer hts = new HashtableSerializer(ss, ss);
        return new Serializer(){

            public void serialize(Object object, DataOutput out) throws IOException {
                hts.serialize(((Properties)object).table, out);
            }

            public Object deserialize(DataInput in) throws IOException {
                return new Properties((Hashtable)hts.deserialize(in));
            }
        };
    }
}

