/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.util;

import java.util.Vector;
import javax.microedition.lcdui.Font;

public class Strings {
    public static String[] parseString(String sourceText, int maxWidth, Font font, char[] forceSeparators, char[][] separators) {
        if (sourceText == null) {
            throw new IllegalArgumentException("Source string can't be null");
        }
        if (maxWidth < 0) {
            throw new IllegalArgumentException("Width must be greater than zero");
        }
        if (font == null) {
            throw new IllegalArgumentException("Font can't be null");
        }
        if (forceSeparators == null) {
            forceSeparators = new char[]{};
        }
        if (separators == null) {
            separators = new char[0][0];
        }
        Vector<String> accumulator = new Vector<String>();
        while (sourceText.length() > 0) {
            int position;
            int previousSeparatorPosition = -1;
            int previousSeparatorLevel = separators.length - 1;
            int width = 0;
            block1: for (position = 0; position < sourceText.length(); ++position) {
                char c2 = sourceText.charAt(position);
                if ((width += font.charWidth(c2)) > maxWidth) {
                    if (previousSeparatorPosition >= 0) {
                        position = previousSeparatorPosition + 1;
                        break;
                    }
                    if (position != 0) break;
                    position = 1;
                    break;
                }
                if (Strings.containsChar(forceSeparators, c2)) {
                    ++position;
                    break;
                }
                for (int i = 0; i <= previousSeparatorLevel; ++i) {
                    if (!Strings.containsChar(separators[i], c2)) continue;
                    previousSeparatorPosition = position;
                    previousSeparatorLevel = i;
                    continue block1;
                }
            }
            accumulator.addElement(sourceText.substring(0, position));
            sourceText = sourceText.substring(position);
        }
        Object[] result = new String[accumulator.size()];
        accumulator.copyInto(result);
        return result;
    }

    private static boolean containsChar(char[] cs, char c2) {
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] != c2) continue;
            return true;
        }
        return false;
    }

    static String trimStart(String s) {
        block3: for (int pos = 0; pos < s.length(); ++pos) {
            switch (s.charAt(pos)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return s.substring(pos);
                }
            }
        }
        return s;
    }

    private Strings() {
    }

    public static Vector splitVector(String data, String separator) {
        int pos;
        if (separator.length() == 0) {
            throw new IllegalArgumentException();
        }
        Vector<String> v = new Vector<String>();
        while (data.length() > 0 && (pos = data.indexOf(separator)) != -1) {
            String item = data.substring(0, pos);
            data = data.substring(pos + separator.length());
            v.addElement(item);
        }
        v.addElement(data);
        return v;
    }

    public static String[] split(String data, String separator) {
        Vector v = Strings.splitVector(data, separator);
        Object[] result = new String[v.size()];
        v.copyInto(result);
        return result;
    }

    public static String replace(String source, String pattern, String replacement) {
        int start = 0;
        while ((start = source.indexOf(pattern, start)) != -1) {
            String prefix = source.substring(0, start);
            String postfix = source.substring(start + pattern.length());
            source = prefix + replacement + postfix;
            start += replacement.length();
        }
        return source;
    }
}

