/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.util;

public class TimerThread
extends Thread {
    Runnable action;
    int interval;
    volatile boolean running;

    public TimerThread(Runnable action, int interval) {
        if (action == null) {
            throw new IllegalArgumentException();
        }
        this.action = action;
        this.interval = interval;
    }

    public void run() {
        this.running = true;
        long taskTime = System.currentTimeMillis();
        while (this.running) {
            this.runAction();
            long curTime = System.currentTimeMillis();
            long delay = (taskTime += (long)this.interval) - curTime;
            do {
                try {
                    if (delay > 0L) {
                        TimerThread.sleep(delay);
                        continue;
                    }
                    TimerThread.sleep(1L);
                    taskTime = curTime;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            } while (taskTime > System.currentTimeMillis());
        }
    }

    private synchronized void runAction() {
        this.action.run();
    }

    public synchronized void cancel() {
        this.running = false;
    }

    private boolean running() {
        return this.running;
    }
}

