/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.util.serialization;

import com.ittop.util.serialization.Serializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ArraySerializer
implements Serializer {
    private final Serializer elementSerializer;

    public ArraySerializer(Serializer elementSerializer) {
        this.elementSerializer = elementSerializer;
    }

    public Object deserialize(DataInput in) throws IOException {
        int length = in.readInt();
        Object[] array = new Object[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.elementSerializer.deserialize(in);
        }
        return array;
    }

    public void serialize(Object object, DataOutput out) throws IOException {
        Object[] array = (Object[])object;
        out.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.elementSerializer.serialize(array[i], out);
        }
    }
}

