/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.util.serialization;

import com.ittop.util.serialization.Serializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class HashtableSerializer
implements Serializer {
    private final Serializer keySerializer;
    private final Serializer valueSerializer;

    public HashtableSerializer(Serializer keySerializer, Serializer valueSerializer) {
        if (keySerializer == null || valueSerializer == null) {
            throw new NullPointerException();
        }
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public void serialize(Object object, DataOutput out) throws IOException {
        Hashtable table = (Hashtable)object;
        int count = table.size();
        out.writeInt(count);
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = table.get(key);
            this.keySerializer.serialize(key, out);
            this.valueSerializer.serialize(value, out);
            --count;
        }
        if (count != 0) {
            throw new IllegalStateException();
        }
    }

    public Object deserialize(DataInput in) throws IOException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        for (int count = in.readInt(); count > 0; --count) {
            String key = in.readUTF();
            String value = in.readUTF();
            table.put(key, value);
        }
        return table;
    }
}

