/*
 * Decompiled with CFR 0.152.
 */
package com.ittop.util.serialization;

import com.ittop.util.serialization.Serializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StringSerializer
implements Serializer {
    private final boolean nullable;

    public StringSerializer(boolean nullable) {
        this.nullable = nullable;
    }

    public StringSerializer() {
        this(true);
    }

    public void serialize(Object object, DataOutput out) throws IOException {
        String s = (String)object;
        if (this.nullable) {
            out.writeBoolean(s != null);
            if (s == null) {
                return;
            }
        }
        out.writeUTF(s);
    }

    public Object deserialize(DataInput in) throws IOException {
        if (this.nullable && !in.readBoolean()) {
            return null;
        }
        return in.readUTF();
    }
}

