/*
 * Decompiled with CFR 0.152.
 */
package mobi.ittop.util.sound;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import mobi.ittop.util.sound.SoundManager;

class Sound
implements PlayerListener {
    private static final Timer timer = new Timer();
    private static final Hashtable mimeTypesByExtension = new Hashtable();
    private final String filepath;
    private final String mimeType;
    private boolean loop;
    private volatile boolean connected;
    private volatile Player player;
    private long startTime;
    private long endTime = Long.MAX_VALUE;
    private SoundManager manager;
    private boolean expired;
    private long time;

    public Sound(SoundManager manager, String filepath, boolean loop, long startTime, String mimeType) {
        if (filepath == null) {
            throw new IllegalArgumentException("Filepath can't be null");
        }
        if (mimeType == null) {
            throw new IllegalArgumentException("Mime type can't be null");
        }
        this.manager = manager;
        this.filepath = filepath;
        this.mimeType = mimeType;
        this.loop = loop;
        this.startTime = startTime;
    }

    public void connect(long time) {
        this.time = time;
        if (this.isConnected()) {
            return;
        }
        this.connected = true;
        TimerTask task = new TimerTask(){

            public void run() {
                try {
                    Sound.this.run();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        timer.schedule(task, 0L);
    }

    private synchronized void run() {
        if (this.endTime < this.time) {
            this.expire();
        }
        Player newPlayer = null;
        InputStream is = this.getClass().getResourceAsStream(this.filepath);
        try {
            long duration;
            newPlayer = Manager.createPlayer((InputStream)is, (String)this.mimeType);
            newPlayer.prefetch();
            if (!this.connected) {
                newPlayer.close();
                return;
            }
            if (this.endTime == Long.MAX_VALUE && (duration = newPlayer.getDuration()) != -1L) {
                this.endTime = this.startTime + duration / 1000L;
            }
            if (this.loop) {
                newPlayer.setLoopCount(-1);
            }
            newPlayer.setMediaTime((this.time - this.startTime) % (this.endTime - this.startTime) * 1000L);
            newPlayer.addPlayerListener((PlayerListener)this);
            if (!this.connected) {
                newPlayer.close();
                return;
            }
            newPlayer.start();
            if (!this.connected) {
                newPlayer.close();
                return;
            }
            this.player = newPlayer;
        }
        catch (Throwable t) {
            System.out.println("Failed creating player for " + this.filepath);
            t.printStackTrace();
            try {
                newPlayer.close();
            }
            catch (Throwable t1) {
                // empty catch block
            }
        }
    }

    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        Player player = this.player;
        this.connected = false;
        if (player != null) {
            player.close();
            player = null;
        }
    }

    public boolean isLooped() {
        return this.loop;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized boolean isExpired(long time) {
        return this.expired;
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (!this.loop && event == "endOfMedia") {
            this.expire();
        }
    }

    private void expire() {
        this.disconnect();
        if (!this.expired && this.manager != null) {
            this.expired = true;
            this.manager.endNotify(this);
        }
    }

    public String getFilepath() {
        return this.filepath;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public static String getMimeType(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("filename must not be null");
        }
        int dotPosition = filename.lastIndexOf(46);
        String extension = filename.substring(dotPosition + 1).toLowerCase();
        String result = (String)mimeTypesByExtension.get(extension);
        if (filename == null) {
            throw new IllegalArgumentException("Could not find MIME type for file " + filename);
        }
        return result;
    }

    static {
        mimeTypesByExtension.put("mp3", "audio/mpeg");
        mimeTypesByExtension.put("wav", "audio/wav");
        mimeTypesByExtension.put("ogg", "audio/ogg");
        mimeTypesByExtension.put("mid", "audio/midi");
        mimeTypesByExtension.put("midi", "audio/midi");
    }
}

