/*
 * Decompiled with CFR 0.152.
 */
package mobi.ittop.util.sound;

import java.util.Vector;
import mobi.ittop.util.sound.Sound;

public class SoundManager {
    private static final boolean mixing = "true".equals(System.getProperty("supports.mixing"));
    private static final int maxPlayers = mixing ? 2 : 1;
    private static boolean mute;
    private static final Object lock;
    private static SoundManager active;
    private Sound bgm;
    private long time = 0L;
    private long lastSyncTime;
    private Vector sounds = new Vector();

    public SoundManager() {
        this.lastSyncTime = System.currentTimeMillis();
    }

    public static void toggleMute() {
        SoundManager.setMute(!SoundManager.isMute());
    }

    public static boolean isMute() {
        return mute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMute(boolean enabled) {
        Object object = lock;
        synchronized (object) {
            mute = enabled;
            if (mute) {
                if (active != null) {
                    active.disconnectAll();
                }
            } else if (active != null) {
                active.connectAll();
            }
        }
    }

    public static SoundManager getActive() {
        return active;
    }

    public boolean isActive() {
        return this == active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setActive(SoundManager s) {
        Object object = lock;
        synchronized (object) {
            if (s != null) {
                s.resume();
            } else if (active != null) {
                active.pause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pause() {
        Object object = lock;
        synchronized (object) {
            if (this.isActive()) {
                this.synchronize();
                this.disconnectAll();
                active = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resume() {
        Object object = lock;
        synchronized (object) {
            if (!this.isActive()) {
                if (active != null) {
                    active.pause();
                }
                this.lastSyncTime = System.currentTimeMillis();
                this.connectAll();
                active = this;
            }
        }
    }

    public synchronized String[] getSoundPaths() {
        String[] result = new String[this.sounds.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((Sound)this.sounds.elementAt(i)).getFilepath();
        }
        return result;
    }

    public void loop(String path) {
        this.start(path, Sound.getMimeType(path), true);
    }

    public void loop(String path, String mimeType) {
        this.start(path, mimeType, true);
    }

    public void play(String path) {
        this.start(path, Sound.getMimeType(path), false);
    }

    public void play(String path, String mimeType) {
        this.start(path, mimeType, false);
    }

    public synchronized void stop(String path) {
        for (int i = this.sounds.size() - 1; i >= 0; --i) {
            Sound s = (Sound)this.sounds.elementAt(i);
            if (!s.getFilepath().equals(path)) continue;
            s.disconnect();
            this.sounds.removeElementAt(i);
        }
        this.connectAll();
    }

    public synchronized void stopAll() {
        this.synchronize();
        this.disconnectAll();
        this.sounds.removeAllElements();
    }

    public synchronized void setBGM(String path, String mimeType) {
        this.synchronize();
        this.cleanup();
        if (this.bgm != null && this.bgm.getFilepath().equals(path)) {
            return;
        }
        if (this.bgm != null) {
            this.bgm.disconnect();
        }
        if (path != null) {
            this.bgm = new Sound(this, path, true, this.time, mimeType);
        }
        this.connectAll();
    }

    public void setBGM(String path) {
        this.setBGM(path, Sound.getMimeType(path));
    }

    public static boolean supportsMixing() {
        return mixing;
    }

    public static String getMimeType(String path) {
        return Sound.getMimeType(path);
    }

    private synchronized void start(String path, String mimeType, boolean loop) {
        this.synchronize();
        this.cleanup();
        int similar = 0;
        for (int i = this.sounds.size() - 1; i >= 0; --i) {
            Sound s = (Sound)this.sounds.elementAt(i);
            if (s.getFilepath() != path || !loop && s.isLooped() || ++similar < maxPlayers) continue;
            s.disconnect();
            this.sounds.removeElementAt(i);
        }
        Sound s = new Sound(this, path, loop, this.time, mimeType);
        this.sounds.addElement(s);
        if (this.isActive()) {
            this.connectAll();
        }
    }

    private synchronized void connectAll() {
        if (mute) {
            return;
        }
        if (this.bgm != null) {
            this.bgm.connect(this.time);
        }
        int firstPlaying = Math.max(0, this.sounds.size() - maxPlayers + (this.bgm != null ? 1 : 0));
        for (int i = 0; i < this.sounds.size(); ++i) {
            Sound s = (Sound)this.sounds.elementAt(i);
            if (i < firstPlaying) {
                s.disconnect();
                continue;
            }
            s.connect(this.time);
        }
    }

    private void disconnectAll() {
        if (this.bgm != null) {
            this.bgm.disconnect();
        }
        for (int i = this.sounds.size() - 1; i >= 0; --i) {
            Sound s = (Sound)this.sounds.elementAt(i);
            s.disconnect();
        }
    }

    private void cleanup() {
        for (int i = this.sounds.size() - 1; i >= 0; --i) {
            Sound s = (Sound)this.sounds.elementAt(i);
            if (!s.isExpired(this.time)) continue;
            this.sounds.removeElementAt(i);
        }
    }

    private void synchronize() {
        if (!this.isActive()) {
            return;
        }
        long now = System.currentTimeMillis();
        this.time += now - this.lastSyncTime;
        this.lastSyncTime = now;
    }

    synchronized void endNotify(Sound s) {
        this.sounds.removeElement(s);
        this.synchronize();
        this.connectAll();
    }

    static {
        lock = new Object();
    }
}

