/*
 * Decompiled with CFR 0.152.
 */
package hello;

import hello.Ball;
import hello.Holes;
import hello.LogoScreen;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameEngine {
    static final int height = 400;
    static final int width = 240;
    boolean collision = false;
    static final int XXL = 46;
    static final int XL = 40;
    static final int L = 36;
    static final int M = 30;
    static final int S = 25;
    static final int XS = 20;
    static final int XXL_radius = 42;
    static final int XL_radius = 37;
    static final int L_radius = 32;
    static final int M_radius = 27;
    static final int S_radius = 22;
    static final int XS_radius = 17;
    static final int collisionIndicationWidth = 60;
    static final int[] collisionIndication = new int[]{0, 64, 127, 190};
    static final int[][] XXLBalls = new int[][]{{0, 0}, {207, 8}, {414, 24}};
    static final int[][] XLBalls = new int[][]{{48, 0}, {254, 32}, {461, 16}};
    static final int[][] LBalls = new int[][]{{89, 0}, {295, 40}, {502, 24}};
    static final int[][] MBalls = new int[][]{{127, 32}, {332, 8}, {538, 40}};
    static final int[][] SBalls = new int[][]{{159, 40}, {366, 8}, {569, 16}};
    static final int[][] XSBalls = new int[][]{{185, 0}, {393, 31}, {595, 24}};
    int level = 0;
    static int map;
    static final int[][][] Ball;
    int[][] animationBall = new int[][]{{0, 46}, {48, 40}, {89, 36}, {127, 30}, {159, 24}, {185, 20}};
    static final int[] smallHole;
    static final int[] mediumHole;
    static final int[] bigHole;
    int[][] blastXY = new int[][]{{0, 54}, {57, 55}, {116, 57}};
    int[][] glowAnimation = new int[][]{{0, 24}, {28, 43}, {75, 53}, {133, 67}, {205, 81}, {296, 98}};
    static final int[][] excellentStrip;
    static final int[][] scoreStrip;
    int indicationFactor = 10;
    int[] ballcnterLimit = new int[]{80, 70, 60, 50, 40, 80, 70, 60, 50, 40, 80, 70, 60, 50, 40, 80, 70, 60, 50, 40};
    static final int[][][] holePos;
    static final int playState = 0;
    static final int gameOverState = 1;
    int currentState = 0;
    Ball[] b;
    Holes[] h;
    boolean[] select;
    Ball.Point Point;
    Image ballstrip = null;
    Image blast = null;
    Image miracle = null;
    Image collisionCircleImage = null;
    Image arrow = null;
    Image excellent = null;
    int[] noOfHoles = new int[]{2, 3, 3, 3};
    int no_of_currentBall = 1;
    int no_of_pottedBall = 0;
    int score = 0;
    int targetScore = 0;
    int star_cnt = 0;
    int halfstar = 0;
    int scoreStripIndex;
    int[] THREESTAR = new int[20];
    int[] TWOANDHALFSTAR = new int[20];
    int[] TWOSTAR = new int[20];
    int[] ONEANDHALFSTAR = new int[20];
    int[] ONESTAR = new int[20];
    int[] HALFSTAR = new int[20];
    int midX;
    int midY;
    int temp = 0;
    float globalM;
    float globalC;
    int holeBlockedCnt = 0;
    int blockedfactor = 0;
    int gradeStripIndex;
    int scoreCnt = 0;
    int gradeCnt = 0;
    int indicationCnt = 0;
    int[] indicationBall_A = new int[2];
    int[] indicationBall_B = new int[2];
    boolean glow = false;
    int glowcnt = 0;
    boolean animationBallPotted = false;
    int pottedAnimationCnt = 0;
    Random rand = new Random();
    int explod = 0;
    int px = 0;
    int py = 0;
    int PERMISSIBLE_RELEASE_X = 10;
    int PERMISSIBLE_RELEASE_Y = 10;
    int cnt = 0;
    int l;
    int PERMISSIBLE_X_FIRST = 10;
    int PERMISSIBLE_Y_FIRST = 10;
    int PERMISSIBLE_X = 40;
    int PERMISSIBLE_Y = 40;
    int pottedHole;
    boolean takeInput = false;
    int t = 0;
    int ballCounter = 0;
    boolean ballIndication = false;

    GameEngine() {
        try {
            this.ballstrip = Image.createImage((String)"/ballstripnew.png");
            this.blast = Image.createImage((String)"/blast.png");
            this.miracle = Image.createImage((String)"/glowanimation.png");
            this.collisionCircleImage = Image.createImage((String)"/collisionindication.png");
            this.arrow = Image.createImage((String)"/ballindication.png");
            this.excellent = Image.createImage((String)"/excellent.png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void resetValues() {
        this.no_of_currentBall = 1;
        this.no_of_pottedBall = 0;
        this.glow = false;
        this.animationBallPotted = false;
        this.star_cnt = 0;
        this.halfstar = 0;
        LogoScreen.levelcompleted = false;
        LogoScreen.levelfailed = false;
        LogoScreen.second = 0;
        LogoScreen.Addsec = 0;
        LogoScreen.Addsec1 = 0;
        LogoScreen.timedifference = 0;
        this.score = 0;
        this.l = 0;
    }

    public void createLevel() {
        int i;
        this.b = new Ball[Ball[this.level].length];
        this.h = new Holes[Ball[this.level].length];
        this.select = new boolean[Ball[this.level].length];
        this.THREESTAR[this.level] = 100 * Ball[this.level].length;
        this.HALFSTAR[this.level] = this.THREESTAR[this.level] / 6;
        this.ONESTAR[this.level] = this.THREESTAR[this.level] / 3;
        this.ONEANDHALFSTAR[this.level] = this.THREESTAR[this.level] / 2;
        this.TWOSTAR[this.level] = this.ONESTAR[this.level] * 2;
        this.TWOANDHALFSTAR[this.level] = this.ONESTAR[this.level] + this.ONEANDHALFSTAR[this.level];
        for (i = 0; i < Ball[this.level].length / 4; ++i) {
            this.b[i] = new Ball(this.GenerateRandomNumber(this.indicationFactor, 240 - this.indicationFactor), this.GenerateRandomNumber(400, 400), Ball[this.level][i][3] / 2, Ball[this.level][i][4]);
        }
        for (i = Ball[this.level].length / 4; i < Ball[this.level].length / 2; ++i) {
            this.b[i] = new Ball(this.GenerateRandomNumber(this.indicationFactor, 240 - this.indicationFactor), this.GenerateRandomNumber(0, 0), Ball[this.level][i][3] / 2, Ball[this.level][i][4]);
        }
        for (i = Ball[this.level].length / 2; i < Ball[this.level].length * 3 / 4; ++i) {
            this.b[i] = new Ball(this.GenerateRandomNumber(0, 0), this.GenerateRandomNumber(this.indicationFactor, 400 - this.indicationFactor), Ball[this.level][i][3] / 2, Ball[this.level][i][4]);
        }
        for (i = Ball[this.level].length * 3 / 4; i < Ball[this.level].length; ++i) {
            this.b[i] = new Ball(this.GenerateRandomNumber(240, 240), this.GenerateRandomNumber(this.indicationFactor, 400 - this.indicationFactor), Ball[this.level][i][3] / 2, Ball[this.level][i][4]);
        }
        for (i = 0; i < this.noOfHoles[map]; ++i) {
            this.h[i] = new Holes(holePos[map][i][2], holePos[map][i][3], holePos[map][i][4] / 2);
        }
    }

    protected void paint(Graphics g) {
        switch (this.currentState) {
            case 0: {
                g.setColor(255, 255, 255);
                g.fillRect(0, 0, 240, 400);
                this.drawBall(g);
                g.setColor(0, 0, 0);
                g.drawString("level : " + (this.level + 1) + "     " + " map : " + (map + 1) + "score : " + this.score, 120, 200, 0);
                break;
            }
            case 1: {
                g.setColor(255, 255, 255);
                g.fillRect(0, 0, 240, 400);
                g.setColor(0, 0, 0);
            }
        }
    }

    public boolean collision() {
        for (int i = 0; i < this.no_of_currentBall; ++i) {
            for (int j = i + 1; j < this.no_of_currentBall; ++j) {
                int d = (int)Math.sqrt((this.b[i].x - this.b[j].x) * (this.b[i].x - this.b[j].x) + (this.b[i].y - this.b[j].y) * (this.b[i].y - this.b[j].y));
                if (d >= this.b[i].bRadius + this.b[j].bRadius) continue;
                this.midX = (this.b[i].x + this.b[j].x) / 2;
                this.midY = (this.b[i].y + this.b[j].y) / 2;
                if (this.b[i].potted || this.b[j].potted) continue;
                LogoScreen.levelfailed = false;
                return true;
            }
        }
        return false;
    }

    public boolean collisionIndication() {
        for (int i = 0; i < this.no_of_currentBall; ++i) {
            for (int j = i + 1; j < this.no_of_currentBall; ++j) {
                if (this.abs(this.b[i].x - this.b[j].x) > this.b[i].bRadius + this.b[j].bRadius + 40 || this.abs(this.b[i].y - this.b[j].y) > this.b[i].bRadius + this.b[j].bRadius + 40) continue;
                this.indicationBall_A[0] = this.b[i].x;
                this.indicationBall_A[1] = this.b[i].y;
                this.indicationBall_B[0] = this.b[j].x;
                this.indicationBall_B[1] = this.b[j].y;
                if (this.b[i].potted || this.b[j].potted) continue;
                return true;
            }
        }
        return false;
    }

    public boolean collisionWithHole() {
        for (int i = 0; i < this.no_of_currentBall; ++i) {
            for (int j = 0; j < this.noOfHoles[map]; ++j) {
                int d;
                if (this.b[i].potted || (d = (int)Math.sqrt((this.b[i].x - this.h[j].x) * (this.b[i].x - this.h[j].x) + (this.b[i].y - this.h[j].y) * (this.b[i].y - this.h[j].y))) >= this.h[j].radius || this.h[j].radius < this.b[i].bRadius) continue;
                int n = this.h[j].radius - this.b[i].bRadius;
                if (n == 0) {
                    n = 1;
                }
                int potScore = 100 / n;
                float m = (float)(this.h[j].y - this.b[i].y) / (float)(this.h[j].x - this.b[i].x);
                float c = (float)this.b[i].y - m * (float)this.b[i].x;
                int x = (int)((c - this.globalC) / (this.globalM - m));
                int y = (int)(m * (float)x + c);
                int d1 = (int)Math.sqrt((this.b[i].x - x) * (this.b[i].x - x) + (this.b[i].y - y) * (this.b[i].y - y));
                if (d1 <= 2) {
                    this.score += 100;
                    this.scoreStripIndex = 0;
                    this.gradeStripIndex = 0;
                    this.b[i].Pott = true;
                }
                if (d1 >= 3 && d1 <= 5) {
                    this.score += 75;
                    this.scoreStripIndex = 1;
                    this.gradeStripIndex = 1;
                    this.b[i].Pott = true;
                }
                if (d1 >= 6 && d1 <= 8) {
                    this.score += 50;
                    this.scoreStripIndex = 2;
                    this.gradeStripIndex = 2;
                    this.b[i].Pott = true;
                }
                if (d1 >= 9 && d1 <= 11) {
                    this.score += 25;
                    this.scoreStripIndex = 3;
                    this.gradeStripIndex = 3;
                    this.b[i].Pott = true;
                }
                if (d1 > 11) {
                    this.score += 5;
                    this.scoreStripIndex = 4;
                    this.gradeStripIndex = 4;
                    this.b[i].Pott = true;
                }
                this.b[i].potted = true;
                this.b[i].points.removeAllElements();
                this.b[i].pottedHole = j;
                this.pottedHole = j;
                ++this.no_of_pottedBall;
                return true;
            }
        }
        return false;
    }

    void drawBall(Graphics g) {
        int i;
        ++this.temp;
        for (i = 0; i < this.noOfHoles[map]; ++i) {
            g.drawRegion(this.ballstrip, holePos[map][i][0], 0, holePos[map][i][1], this.ballstrip.getHeight(), 0, this.h[i].x, this.h[i].y, 1 | 2);
        }
        if (!this.collision) {
            for (i = 0; i < this.no_of_currentBall; ++i) {
                boolean ballDrawn = false;
                if (!this.b[i].potted) {
                    Ball.Point s;
                    if (this.b[i].holeBlocked) {
                        if (this.holeBlockedCnt < 3) {
                            if (++this.blockedfactor % 5 == 0) {
                                ++this.holeBlockedCnt;
                            }
                        } else {
                            this.holeBlockedCnt = 0;
                            this.blockedfactor = 0;
                        }
                    }
                    Enumeration p = this.b[i].points.elements();
                    int n = 0;
                    while (p.hasMoreElements()) {
                        p.nextElement();
                        ++n;
                    }
                    p = this.b[i].points.elements();
                    n = 0;
                    int x = 0;
                    int y = 0;
                    int x1 = 0;
                    int y1 = 0;
                    if (p.hasMoreElements()) {
                        s = (Ball.Point)p.nextElement();
                        x = s.x;
                        y = s.y;
                    }
                    while (p.hasMoreElements()) {
                        s = (Ball.Point)p.nextElement();
                        x1 = s.x;
                        y1 = s.y;
                        x = s.x;
                        y = s.y;
                        ++n;
                    }
                    if (n > 3) {
                        p = this.b[i].points.elements();
                        s = (Ball.Point)p.nextElement();
                        Ball.Point s1 = (Ball.Point)p.nextElement();
                        int startPoint = 0;
                        while (p.hasMoreElements()) {
                            Ball.Point s2 = (Ball.Point)p.nextElement();
                            if (!p.hasMoreElements()) continue;
                            Ball.Point s3 = (Ball.Point)p.nextElement();
                            int xx1 = 0;
                            int yy1 = 0;
                            this.globalM = (float)(s3.y - s2.y) / (float)(s3.x - s2.x);
                            this.globalC = (float)this.b[i].y - this.b[i].m * (float)this.b[i].x;
                            float t = 0.0f;
                            while ((double)t < 1.0) {
                                g.setColor(0, 0, 0);
                                int xx = (int)((1.0f - t) * (1.0f - t) * (1.0f - t) * (float)s.x + 3.0f * (1.0f - t) * (1.0f - t) * t * (float)s1.x + 3.0f * (1.0f - t) * t * t * (float)s2.x + t * t * t * (float)s3.x);
                                int yy = (int)((1.0f - t) * (1.0f - t) * (1.0f - t) * (float)s.y + 3.0f * (1.0f - t) * (1.0f - t) * t * (float)s1.y + 3.0f * (1.0f - t) * t * t * (float)s2.y + t * t * t * (float)s3.y);
                                if (xx1 != 0 && yy1 != 0 && t + (float)startPoint > this.b[i].ballTravel) {
                                    g.drawLine(xx, yy, xx1, yy1);
                                }
                                if (!ballDrawn && (float)(this.b[i].points.size() / 2) > this.b[i].ballTravel && this.abs(t + (float)startPoint - this.b[i].ballTravel) > 0.0f && this.abs(t + (float)startPoint - this.b[i].ballTravel) < 0.05f) {
                                    this.b[i].x = xx;
                                    this.b[i].y = yy;
                                    if (this.b[i].ballType != Ball[this.level][i][4]) {
                                        if (this.temp % 2 == 0) {
                                            // empty if block
                                        }
                                    } else {
                                        g.drawRegion(this.ballstrip, Ball[this.level][i][0], 0, Ball[this.level][i][1], this.ballstrip.getHeight(), 0, this.b[i].x, this.b[i].y, 1 | 2);
                                    }
                                    ballDrawn = true;
                                }
                                if (ballDrawn) {
                                    if (s3.x - s2.x != 0) {
                                        this.b[i].m = (float)(s3.y - s2.y) / (float)(s3.x - s2.x);
                                        this.b[i].xSide = s3.x - s2.x > 0 ? 1 : -1;
                                    } else {
                                        this.b[i].m = s3.y - s2.y;
                                        this.b[i].xSide = 1;
                                    }
                                }
                                xx1 = xx;
                                yy1 = yy;
                                t += 0.03f;
                            }
                            ++startPoint;
                            s = s3;
                            Ball ball = this.b[i];
                            ball.getClass();
                            s1 = ball.new Ball.Point(s3.x + (s3.x - s2.x), s3.y + (s3.y - s2.y));
                        }
                    }
                    if (!ballDrawn) {
                        if (!this.b[i].holeBlocked) {
                            if (this.b[i].x - this.b[i].bRadius < 0) {
                                this.b[i].x = this.b[i].bRadius;
                                this.b[i].m *= -1.0f;
                                this.b[i].xSide = 1;
                            }
                            if (this.b[i].x + this.b[i].bRadius > 240) {
                                this.b[i].x = 240 - this.b[i].bRadius;
                                this.b[i].m *= -1.0f;
                                this.b[i].xSide = -1;
                            }
                            if (this.b[i].y - this.b[i].bRadius < 0) {
                                this.b[i].y = this.b[i].bRadius;
                                this.b[i].m *= -1.0f;
                            }
                            if (this.b[i].y + this.b[i].bRadius > 400) {
                                this.b[i].y = 400 - this.b[i].bRadius;
                                this.b[i].m *= -1.0f;
                            }
                            if (this.b[i].m > 10.0f || this.b[i].m < -10.0f) {
                                this.b[i].m = this.b[i].m < 0.0f ? -2.0f : 2.0f;
                            }
                            this.b[i].c = (float)this.b[i].y - this.b[i].m * (float)this.b[i].x;
                            this.b[i].x += this.b[i].xSide;
                            this.b[i].y = (int)((float)this.b[i].x * this.b[i].m + this.b[i].c);
                        }
                        if (this.b[i].ballType != Ball[this.level][i][4]) {
                            if (this.temp % 2 == 0) {
                                // empty if block
                            }
                        } else {
                            g.drawRegion(this.ballstrip, Ball[this.level][i][0], 0, Ball[this.level][i][1], this.ballstrip.getHeight(), 0, this.b[i].x, this.b[i].y, 1 | 2);
                        }
                    }
                }
                if (this.b[i].Pott) {
                    g.drawRegion(this.excellent, scoreStrip[this.scoreStripIndex][0], 0, scoreStrip[this.scoreStripIndex][1], this.excellent.getHeight(), 0, this.h[this.b[i].pottedHole].x, this.h[this.b[i].pottedHole].y - this.scoreCnt, 1 | 2);
                    if (this.scoreCnt < 50) {
                        this.scoreCnt += 2;
                    } else {
                        this.b[i].Pott = false;
                        this.scoreCnt = 0;
                        this.b[i].gradeAnimation = true;
                    }
                }
                if (!this.b[i].gradeAnimation) continue;
                g.drawRegion(this.excellent, excellentStrip[this.gradeStripIndex][0], 0, excellentStrip[this.gradeStripIndex][1], this.excellent.getHeight(), 0, this.h[this.b[i].pottedHole].x, this.h[this.b[i].pottedHole].y - this.gradeCnt, 1 | 2);
                if (this.gradeCnt < 50) {
                    this.gradeCnt += 2;
                    continue;
                }
                this.gradeCnt = 0;
                this.b[i].gradeAnimation = false;
            }
        }
        if (this.ballIndication) {
            if (this.b[this.no_of_currentBall].x <= 240 && this.b[this.no_of_currentBall].x >= 0 && this.b[this.no_of_currentBall].y <= 400 && this.b[this.no_of_currentBall].y >= 400) {
                g.drawRegion(this.arrow, 0, 0, this.arrow.getWidth(), this.arrow.getHeight(), 0, this.b[this.no_of_currentBall].x, this.b[this.no_of_currentBall].y - this.indicationFactor, 1 | 2);
            }
            if (this.b[this.no_of_currentBall].x <= 240 && this.b[this.no_of_currentBall].x >= 0 && this.b[this.no_of_currentBall].y <= 0 && this.b[this.no_of_currentBall].y >= 0) {
                g.drawRegion(this.arrow, 0, 0, this.arrow.getWidth(), this.arrow.getHeight(), 1, this.b[this.no_of_currentBall].x, this.b[this.no_of_currentBall].y + this.indicationFactor, 1 | 2);
            }
            if (this.b[this.no_of_currentBall].x <= 0 && this.b[this.no_of_currentBall].x >= 0 && this.b[this.no_of_currentBall].y <= 400 && this.b[this.no_of_currentBall].y >= 0) {
                g.drawRegion(this.arrow, 0, 0, this.arrow.getWidth(), this.arrow.getHeight(), 7, this.b[this.no_of_currentBall].x + this.indicationFactor, this.b[this.no_of_currentBall].y, 1 | 2);
            }
            if (this.b[this.no_of_currentBall].x <= 240 && this.b[this.no_of_currentBall].x >= 240 && this.b[this.no_of_currentBall].y <= 400 && this.b[this.no_of_currentBall].y >= 0) {
                g.drawRegion(this.arrow, 0, 0, this.arrow.getWidth(), this.arrow.getHeight(), 4, this.b[this.no_of_currentBall].x - this.indicationFactor, this.b[this.no_of_currentBall].y, 1 | 2);
            }
        }
        if (this.collision()) {
            this.collision = true;
        }
        if (this.collision) {
            ++this.explod;
            if (this.t < 3) {
                g.drawRegion(this.blast, this.blastXY[this.t][0], 0, this.blastXY[this.t][1], this.blast.getHeight(), 0, this.midX, this.midY, 1 | 2);
                if (this.explod % 5 == 0) {
                    ++this.t;
                }
            } else {
                this.t = 0;
                this.explod = 0;
                this.collision = false;
                LogoScreen.levelfailed = true;
                this.currentState = 1;
            }
        }
        if (this.collisionIndication()) {
            g.drawRegion(this.collisionCircleImage, collisionIndication[this.indicationCnt], 0, 60, this.collisionCircleImage.getHeight(), 0, this.indicationBall_A[0], this.indicationBall_A[1], 1 | 2);
            g.drawRegion(this.collisionCircleImage, collisionIndication[this.indicationCnt], 0, 60, this.collisionCircleImage.getHeight(), 0, this.indicationBall_B[0], this.indicationBall_B[1], 1 | 2);
            this.indicationCnt = this.indicationCnt < 3 ? ++this.indicationCnt : 0;
        }
        if (this.collisionWithHole()) {
            this.animationBallPotted = true;
        }
        if (this.animationBallPotted) {
            ++this.explod;
            if (this.pottedAnimationCnt < 6) {
                g.drawRegion(this.ballstrip, this.animationBall[this.pottedAnimationCnt][0], 0, this.animationBall[this.pottedAnimationCnt][1], this.ballstrip.getHeight(), 0, this.h[this.pottedHole].x, this.h[this.pottedHole].y, 1 | 2);
                if (this.explod % 3 == 0) {
                    ++this.pottedAnimationCnt;
                }
            } else {
                this.animationBallPotted = false;
                this.pottedAnimationCnt = 0;
                this.explod = 0;
                this.glow = true;
            }
        }
        if (this.glow) {
            ++this.explod;
            if (this.glowcnt < 6) {
                g.drawRegion(this.miracle, this.glowAnimation[this.glowcnt][0], 0, this.glowAnimation[this.glowcnt][1], this.miracle.getHeight(), 0, this.h[this.pottedHole].x, this.h[this.pottedHole].y, 1 | 2);
                if (this.explod % 3 == 0) {
                    ++this.glowcnt;
                }
            } else {
                this.glow = false;
                this.glowcnt = 0;
                this.explod = 0;
                if (Ball[this.level].length == this.no_of_pottedBall) {
                    this.currentState = 1;
                }
            }
        }
    }

    public int GenerateRandomNumber(int min, int max) {
        int ra = Math.abs(this.rand.nextInt());
        if (ra < 0) {
            ra = -ra;
        }
        return ra % (max - min + 1) + min;
    }

    int abs(int g) {
        if (g < 0) {
            return g * -1;
        }
        return g;
    }

    float abs(float g) {
        if (g < 0.0f) {
            return g * -1.0f;
        }
        return g;
    }

    static {
        Ball = new int[][][]{new int[][]{{SBalls[1][0], 25, SBalls[1][1], 22, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {MBalls[0][0], 30, MBalls[0][1], 27, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {XLBalls[2][0], 40, XLBalls[2][1], 37, 0}}, new int[][]{{SBalls[0][0], 25, SBalls[0][1], 22, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XLBalls[2][0], 40, XLBalls[2][1], 37, 0}, {MBalls[0][0], 30, MBalls[0][1], 27, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {MBalls[1][0], 30, MBalls[1][1], 27, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {XXLBalls[1][0], 46, XXLBalls[1][1], 42, 0}}, new int[][]{{SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {XXLBalls[2][0], 46, XXLBalls[2][1], 42, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}}, new int[][]{{XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {MBalls[0][0], 30, MBalls[0][1], 27, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {XXLBalls[2][0], 46, XXLBalls[2][1], 42, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {MBalls[0][0], 30, MBalls[0][1], 27, 0}, {XXLBalls[1][0], 46, XXLBalls[1][1], 42, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {MBalls[0][0], 30, MBalls[0][1], 27, 0}, {XXLBalls[1][0], 46, XXLBalls[1][1], 42, 0}, {LBalls[2][0], 36, LBalls[2][1], 32, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {XLBalls[1][0], 40, XLBalls[1][1], 37, 0}}, new int[][]{{MBalls[2][0], 30, MBalls[2][1], 27, 0}, {LBalls[0][0], 36, LBalls[0][1], 32, 0}, {XXLBalls[1][0], 46, XXLBalls[1][1], 42, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {XXLBalls[1][0], 46, XXLBalls[1][1], 42, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {LBalls[0][0], 36, LBalls[0][1], 32, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XXLBalls[2][0], 46, XXLBalls[2][1], 42, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {XLBalls[1][0], 40, XLBalls[1][1], 37, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {LBalls[0][0], 36, LBalls[0][1], 32, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {XXLBalls[1][0], 46, XXLBalls[1][1], 42, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}}, new int[][]{{SBalls[1][0], 25, SBalls[1][1], 22, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {MBalls[1][0], 30, MBalls[1][1], 27, 0}, {LBalls[2][0], 36, LBalls[2][1], 32, 0}}, new int[][]{{SBalls[2][0], 25, SBalls[2][1], 22, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {MBalls[1][0], 30, MBalls[1][1], 27, 0}, {LBalls[2][0], 36, LBalls[2][1], 32, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {MBalls[1][0], 30, MBalls[1][1], 27, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {LBalls[2][0], 36, LBalls[2][1], 32, 0}}, new int[][]{{XLBalls[1][0], 40, XLBalls[1][1], 37, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {MBalls[1][0], 30, MBalls[1][1], 27, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {LBalls[2][0], 36, LBalls[2][1], 32, 0}, {XLBalls[1][0], 40, XLBalls[1][1], 37, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {MBalls[1][0], 30, MBalls[1][1], 27, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {MBalls[1][0], 30, MBalls[1][1], 27, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}}, new int[][]{{MBalls[1][0], 30, MBalls[1][1], 27, 0}, {LBalls[2][0], 36, LBalls[2][1], 32, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XLBalls[2][0], 40, XLBalls[2][1], 37, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {MBalls[1][0], 30, MBalls[1][1], 27, 0}, {LBalls[2][0], 36, LBalls[2][1], 32, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XXLBalls[2][0], 46, XXLBalls[2][1], 42, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {LBalls[2][0], 36, LBalls[2][1], 32, 0}, {LBalls[0][0], 36, LBalls[0][1], 32, 0}, {MBalls[1][0], 30, MBalls[1][1], 27, 0}, {XXLBalls[2][0], 46, XXLBalls[2][1], 42, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}}, new int[][]{{SBalls[2][0], 25, SBalls[2][1], 22, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {MBalls[1][0], 30, MBalls[1][1], 27, 0}, {LBalls[2][0], 36, LBalls[2][1], 32, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XLBalls[2][0], 40, XLBalls[2][1], 37, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {XXLBalls[1][0], 46, XXLBalls[1][1], 42, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {LBalls[0][0], 36, LBalls[0][1], 32, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XLBalls[2][0], 40, XLBalls[2][1], 37, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {XXLBalls[1][0], 46, XXLBalls[1][1], 42, 0}, {LBalls[2][0], 36, LBalls[2][1], 32, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {LBalls[0][0], 36, LBalls[0][1], 32, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XXLBalls[2][0], 46, XXLBalls[2][1], 42, 0}}, new int[][]{{SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XLBalls[2][0], 40, XLBalls[2][1], 37, 0}, {MBalls[0][0], 30, MBalls[0][1], 27, 0}, {LBalls[2][0], 36, LBalls[2][1], 32, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}}, new int[][]{{XLBalls[2][0], 40, XLBalls[2][1], 37, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {XLBalls[2][0], 40, XLBalls[2][1], 37, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}}, new int[][]{{MBalls[2][0], 30, MBalls[2][1], 27, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {XLBalls[1][0], 40, XLBalls[1][1], 37, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {LBalls[2][0], 36, LBalls[2][1], 32, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {MBalls[0][0], 30, MBalls[0][1], 27, 0}}, new int[][]{{SBalls[0][0], 25, SBalls[0][1], 22, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {XLBalls[1][0], 40, XLBalls[1][1], 37, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XXLBalls[2][0], 46, XXLBalls[2][1], 42, 0}, {MBalls[0][0], 30, MBalls[0][1], 27, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {XXLBalls[1][0], 46, XXLBalls[1][1], 42, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {MBalls[0][0], 30, MBalls[0][1], 27, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XXLBalls[2][0], 46, XXLBalls[2][1], 42, 0}, {LBalls[0][0], 36, LBalls[0][1], 32, 0}, {XLBalls[1][0], 40, XLBalls[1][1], 37, 0}}, new int[][]{{SBalls[1][0], 25, SBalls[1][1], 22, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {XLBalls[2][0], 40, XLBalls[2][1], 37, 0}, {MBalls[1][0], 30, MBalls[1][1], 27, 0}, {LBalls[0][0], 36, LBalls[0][1], 32, 0}, {XXLBalls[2][0], 46, XXLBalls[2][1], 42, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {XXLBalls[2][0], 46, XXLBalls[2][1], 42, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {XXLBalls[1][0], 46, XXLBalls[1][1], 42, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {XLBalls[2][0], 40, XLBalls[2][1], 37, 0}, {MBalls[1][0], 30, MBalls[1][1], 27, 0}}, new int[][]{{XLBalls[2][0], 40, XLBalls[2][1], 37, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}}, new int[][]{{MBalls[1][0], 30, MBalls[1][1], 27, 0}, {LBalls[2][0], 36, LBalls[2][1], 32, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XLBalls[2][0], 40, XLBalls[2][1], 37, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {MBalls[1][0], 30, MBalls[1][1], 27, 0}, {LBalls[2][0], 36, LBalls[2][1], 32, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}}, new int[][]{{SBalls[1][0], 25, SBalls[1][1], 22, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {XLBalls[1][0], 40, XLBalls[1][1], 37, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {XXLBalls[2][0], 46, XXLBalls[2][1], 42, 0}, {MBalls[1][0], 30, MBalls[1][1], 27, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {XLBalls[1][0], 40, XLBalls[1][1], 37, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}}, new int[][]{{SBalls[2][0], 25, SBalls[2][1], 22, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {XLBalls[1][0], 40, XLBalls[1][1], 37, 0}, {MBalls[0][0], 30, MBalls[0][1], 27, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {MBalls[0][0], 30, MBalls[0][1], 27, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {XLBalls[1][0], 40, XLBalls[1][1], 37, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {LBalls[2][0], 36, LBalls[2][1], 32, 0}, {XXLBalls[1][0], 46, XXLBalls[1][1], 42, 0}, {MBalls[0][0], 30, MBalls[0][1], 27, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}}, new int[][]{{SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XLBalls[0][0], 40, XLBalls[0][1], 37, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {LBalls[2][0], 36, LBalls[2][1], 32, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {LBalls[1][0], 36, LBalls[1][1], 32, 0}, {SBalls[0][0], 25, SBalls[0][1], 22, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {XLBalls[1][0], 40, XLBalls[1][1], 37, 0}, {XXLBalls[0][0], 46, XXLBalls[0][1], 42, 0}, {SBalls[2][0], 25, SBalls[2][1], 22, 0}, {SBalls[1][0], 25, SBalls[1][1], 22, 0}, {LBalls[0][0], 36, LBalls[0][1], 32, 0}, {MBalls[2][0], 30, MBalls[2][1], 27, 0}, {XXLBalls[1][0], 46, XXLBalls[1][1], 42, 0}}};
        smallHole = new int[]{617, 27};
        mediumHole = new int[]{647, 37};
        bigHole = new int[]{687, 46};
        excellentStrip = new int[][]{{0, 74}, {79, 42}, {128, 20}, {151, 33}, {191, 73}};
        scoreStrip = new int[][]{{271, 40}, {319, 31}, {359, 34}, {401, 31}, {441, 21}};
        holePos = new int[][][]{new int[][]{{bigHole[0], bigHole[1], 93, 120, bigHole[1]}, {smallHole[0], smallHole[1], 170, 300, smallHole[1]}}, new int[][]{{bigHole[0], bigHole[1], 52, 68, bigHole[1]}, {smallHole[0], smallHole[1], 192, 128, smallHole[1]}, {mediumHole[0], mediumHole[1], 110, 212, mediumHole[1]}}, new int[][]{{bigHole[0], bigHole[1], 55, 60, bigHole[1]}, {smallHole[0], smallHole[1], 62, 204, smallHole[1]}, {mediumHole[0], mediumHole[1], 168, 276, mediumHole[1]}}, new int[][]{{bigHole[0], bigHole[1], 110, 260, bigHole[1]}, {smallHole[0], smallHole[1], 139, 180, smallHole[1]}, {mediumHole[0], mediumHole[1], 165, 80, mediumHole[1]}}};
    }
}

